/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.metrics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.util.Locale;
import org.jensoft.core.graphics.Antialiasing;
import org.jensoft.core.graphics.TextAntialiasing;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.metrics.Metrics;
import org.jensoft.core.plugin.metrics.format.IMetricsFormat;
import org.jensoft.core.plugin.metrics.manager.AbstractMetricsManager;
import org.jensoft.core.plugin.metrics.painter.AbstractMetricsPainter;
import org.jensoft.core.plugin.metrics.painter.MetricsGlyphPainter;

public abstract class AbstractMetricsPlugin<M extends AbstractMetricsManager>
extends AbstractPlugin {
    private M metricsManager;
    private AbstractMetricsPainter metricsPainter;
    private Metrics.Gravity gravity = Metrics.Gravity.Natural;
    private boolean baseLinePaint = false;
    private Color baseLineColor;
    private Stroke baseLineStroke = new BasicStroke();
    private int minorMarkerSize = 2;
    private Color minorMarkerColor;
    private Stroke minorMarkerStroke = new BasicStroke();
    private int medianMarkerSize = 4;
    private Color medianMarkerColor;
    private Stroke medianMarkerStroke = new BasicStroke();
    private int medianTextOffset = 5;
    private Color medianTextColor;
    private Font medianTextFont = new Font("Dialog", 0, 10);
    private int majorMarkerSize = 6;
    private Color majorMarkerColor;
    private Stroke majorMarkerStroke = new BasicStroke();
    private int majorTextOffset = 10;
    private Color majorTextColor;
    private Font majorTextFont = new Font("Dialog", 0, 12);
    private Locale locale;
    private String suffix;
    private IMetricsFormat format;

    public AbstractMetricsPlugin(M manager) {
        this.metricsPainter = new MetricsGlyphPainter();
        this.setPriority(1000);
        this.setTextAntialising(TextAntialiasing.On);
        this.setAntialiasing(Antialiasing.On);
        this.metricsManager = manager;
    }

    public M getMetricsManager() {
        return this.metricsManager;
    }

    public void setMetricsManager(M metricsManager) {
        this.metricsManager = metricsManager;
    }

    public AbstractMetricsPainter getMetricsPainter() {
        return this.metricsPainter;
    }

    public void setMetricsPainter(AbstractMetricsPainter metricsPainter) {
        this.metricsPainter = metricsPainter;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public IMetricsFormat getFormat() {
        return this.format;
    }

    public void setFormat(IMetricsFormat format) {
        this.format = format;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public Metrics.Gravity getGravity() {
        return this.gravity;
    }

    public void setGravity(Metrics.Gravity gravity) {
        this.gravity = gravity;
    }

    public boolean isBaseLinePaint() {
        return this.baseLinePaint;
    }

    public void setBaseLinePaint(boolean baseLinePaint) {
        this.baseLinePaint = baseLinePaint;
    }

    public Color getBaseLineColor() {
        return this.baseLineColor;
    }

    public void setBaseLineColor(Color baseLineColor) {
        this.baseLineColor = baseLineColor;
    }

    public Stroke getBaseLineStroke() {
        return this.baseLineStroke;
    }

    public void setBaseLineStroke(Stroke baseLineStroke) {
        this.baseLineStroke = baseLineStroke;
    }

    public void setMarkerColor(Color color) {
        this.minorMarkerColor = color;
        this.medianMarkerColor = color;
        this.majorMarkerColor = color;
    }

    public void setTextColor(Color color) {
        this.medianTextColor = color;
        this.majorTextColor = color;
    }

    public void setTextFont(Font font) {
        this.medianTextFont = font;
        this.majorTextFont = font;
    }

    public Font getMetricsTextFont(Metrics metrics) {
        if (metrics.getNature() == Metrics.MetricsNature.Minor) {
            return null;
        }
        if (metrics.getNature() == Metrics.MetricsNature.Major) {
            return this.majorTextFont;
        }
        if (metrics.getNature() == Metrics.MetricsNature.Median) {
            return this.medianTextFont;
        }
        return null;
    }

    public int getMetricsTextOffset(Metrics metrics) {
        if (metrics.getNature() == Metrics.MetricsNature.Minor) {
            return 0;
        }
        if (metrics.getNature() == Metrics.MetricsNature.Major) {
            return this.majorTextOffset;
        }
        if (metrics.getNature() == Metrics.MetricsNature.Median) {
            return this.medianTextOffset;
        }
        return 0;
    }

    public int getMetricsMarkerSize(Metrics metrics) {
        if (metrics.getNature() == Metrics.MetricsNature.Minor) {
            return this.minorMarkerSize;
        }
        if (metrics.getNature() == Metrics.MetricsNature.Major) {
            return this.majorMarkerSize;
        }
        if (metrics.getNature() == Metrics.MetricsNature.Median) {
            return this.medianMarkerSize;
        }
        return 0;
    }

    public Stroke getMetricsMarkerStroke(Metrics metrics) {
        if (metrics.getNature() == Metrics.MetricsNature.Minor) {
            return this.minorMarkerStroke;
        }
        if (metrics.getNature() == Metrics.MetricsNature.Major) {
            return this.majorMarkerStroke;
        }
        if (metrics.getNature() == Metrics.MetricsNature.Median) {
            return this.medianMarkerStroke;
        }
        return null;
    }

    public Color getMetricsTextColor(Metrics metrics) {
        if (metrics.getNature() == Metrics.MetricsNature.Minor) {
            return null;
        }
        if (metrics.getNature() == Metrics.MetricsNature.Major) {
            return this.majorTextColor;
        }
        if (metrics.getNature() == Metrics.MetricsNature.Median) {
            return this.medianTextColor;
        }
        return null;
    }

    public Color getMetricsMarkerColor(Metrics metrics) {
        if (metrics.getNature() == Metrics.MetricsNature.Minor) {
            return this.minorMarkerColor;
        }
        if (metrics.getNature() == Metrics.MetricsNature.Major) {
            return this.majorMarkerColor;
        }
        if (metrics.getNature() == Metrics.MetricsNature.Median) {
            return this.medianMarkerColor;
        }
        return null;
    }

    public int getMinorMarkerSize() {
        return this.minorMarkerSize;
    }

    public void setMinorMarkerSize(int minorMarkerSize) {
        this.minorMarkerSize = minorMarkerSize;
    }

    public Color getMinorMarkerColor() {
        return this.minorMarkerColor;
    }

    public void setMinorMarkerColor(Color minorMarkerColor) {
        this.minorMarkerColor = minorMarkerColor;
    }

    public Stroke getMinorMarkerStroke() {
        return this.minorMarkerStroke;
    }

    public void setMinorMarkerStroke(Stroke minorMarkerStroke) {
        this.minorMarkerStroke = minorMarkerStroke;
    }

    public int getMedianMarkerSize() {
        return this.medianMarkerSize;
    }

    public void setMedianMarkerSize(int medianMarkerSize) {
        this.medianMarkerSize = medianMarkerSize;
    }

    public Color getMedianMarkerColor() {
        return this.medianMarkerColor;
    }

    public void setMedianMarkerColor(Color medianMarkerColor) {
        this.medianMarkerColor = medianMarkerColor;
    }

    public Stroke getMedianMarkerStroke() {
        return this.medianMarkerStroke;
    }

    public void setMedianMarkerStroke(Stroke medianMarkerStroke) {
        this.medianMarkerStroke = medianMarkerStroke;
    }

    public int getMedianTextOffset() {
        return this.medianTextOffset;
    }

    public void setMedianTextOffset(int medianTextOffset) {
        this.medianTextOffset = medianTextOffset;
    }

    public Color getMedianTextColor() {
        return this.medianTextColor;
    }

    public void setMedianTextColor(Color medianTextColor) {
        this.medianTextColor = medianTextColor;
    }

    public Font getMedianTextFont() {
        return this.medianTextFont;
    }

    public void setMedianTextFont(Font medianTextFont) {
        this.medianTextFont = medianTextFont;
    }

    public int getMajorMarkerSize() {
        return this.majorMarkerSize;
    }

    public void setMajorMarkerSize(int majorMarkerSize) {
        this.majorMarkerSize = majorMarkerSize;
    }

    public Color getMajorMarkerColor() {
        return this.majorMarkerColor;
    }

    public void setMajorMarkerColor(Color majorMarkerColor) {
        this.majorMarkerColor = majorMarkerColor;
    }

    public Stroke getMajorMarkerStroke() {
        return this.majorMarkerStroke;
    }

    public void setMajorMarkerStroke(Stroke majorMarkerStroke) {
        this.majorMarkerStroke = majorMarkerStroke;
    }

    public int getMajorTextOffset() {
        return this.majorTextOffset;
    }

    public void setMajorTextOffset(int majorTextOffset) {
        this.majorTextOffset = majorTextOffset;
    }

    public Color getMajorTextColor() {
        return this.majorTextColor;
    }

    public void setMajorTextColor(Color majorTextColor) {
        this.majorTextColor = majorTextColor;
    }

    public Font getMajorTextFont() {
        return this.majorTextFont;
    }

    public void setMajorTextFont(Font majorTextFont) {
        this.majorTextFont = majorTextFont;
    }
}

