/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.metrics;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.List;
import org.jensoft.core.plugin.metrics.AbstractMetricsPlugin;
import org.jensoft.core.plugin.metrics.AxisMetricsPlugin;
import org.jensoft.core.plugin.metrics.Metrics;
import org.jensoft.core.plugin.metrics.format.IMetricsFormat;
import org.jensoft.core.plugin.metrics.manager.AbstractMetricsManager;
import org.jensoft.core.plugin.metrics.manager.FlowMetricsManager;
import org.jensoft.core.plugin.metrics.manager.FreeMetricsManager;
import org.jensoft.core.plugin.metrics.manager.ModeledMetricsManager;
import org.jensoft.core.plugin.metrics.manager.StaticMetricsManager;
import org.jensoft.core.plugin.metrics.manager.TimeMetricsManager;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public abstract class DeviceMetricsPlugin<M extends AbstractMetricsManager>
extends AbstractMetricsPlugin<M> {
    private double baseLine;
    private DeviceAxis deviceAxis;
    private Metrics.MarkerPosition deviceMarkerPosition;

    public DeviceMetricsPlugin(M manager, double baseLine, DeviceAxis deviceAxis) {
        super(manager);
        this.baseLine = baseLine;
        this.deviceAxis = deviceAxis;
    }

    public DeviceMetricsPlugin(M manager, double baseLine, Metrics.MarkerPosition deviceMarkerPosition, DeviceAxis deviceAxis) {
        this(manager, baseLine, deviceAxis);
        this.deviceMarkerPosition = deviceMarkerPosition;
    }

    public Metrics.MarkerPosition getDeviceMarkerPosition() {
        return this.deviceMarkerPosition;
    }

    public void setDeviceMarkerPosition(Metrics.MarkerPosition deviceMarkerPosition) {
        this.deviceMarkerPosition = deviceMarkerPosition;
    }

    private boolean isAccessible(ViewPart viewPart) {
        return viewPart == ViewPart.Device;
    }

    public void setMetricsFormat(IMetricsFormat format) {
        ((AbstractMetricsManager)this.getMetricsManager()).setMetricsFormat(format);
    }

    public IMetricsFormat getMetricsFormat() {
        return ((AbstractMetricsManager)this.getMetricsManager()).getMetricsFormat();
    }

    private void assignType() {
        if (this.deviceAxis == DeviceAxis.AxisX) {
            ((AbstractMetricsManager)this.getMetricsManager()).setMetricsType(Metrics.MetricsType.XMetrics);
        }
        if (this.deviceAxis == DeviceAxis.AxisY) {
            ((AbstractMetricsManager)this.getMetricsManager()).setMetricsType(Metrics.MetricsType.YMetrics);
        }
    }

    protected void paintMetricsX(View v2d, Graphics2D g2d, List<Metrics> metricsX, double baseLine, int offsetPixel) {
        Point2D deviceBaseLine = this.getProjection().userToPixel(new Point2D.Double(0.0, baseLine));
        for (Metrics m : metricsX) {
            if (Metrics.MarkerPosition.isXCompatible(this.deviceMarkerPosition)) {
                m.setMarkerPosition(this.deviceMarkerPosition);
            } else {
                m.setMarkerPosition(Metrics.MarkerPosition.S);
            }
            m.setLockMarker(true);
            if (offsetPixel > 0) {
                m.setLockMarker(false);
            }
            Point2D.Double p = new Point2D.Double();
            if (m.getMarkerPosition() == Metrics.MarkerPosition.S) {
                p = new Point2D.Double(m.getDeviceValue(), deviceBaseLine.getY() + (double)offsetPixel);
            }
            if (m.getMarkerPosition() == Metrics.MarkerPosition.N) {
                p = new Point2D.Double(m.getDeviceValue(), deviceBaseLine.getY() - (double)offsetPixel);
            }
            m.setMarkerLocation(p);
        }
        this.getMetricsPainter().doPaintMetrics(g2d, metricsX);
    }

    protected void paintMetricsXBaseLine(View view, Graphics2D g2d, double baseLine) {
        Point2D deviceBaseLine = this.getProjection().userToPixel(new Point2D.Double(0.0, baseLine));
        Color axisBaseLineColor = this.getBaseLineColor() != null ? this.getBaseLineColor() : this.getProjection().getThemeColor();
        this.getMetricsPainter().doPaintLineMetrics(g2d, new Point2D.Double(0.0, deviceBaseLine.getY()), new Point2D.Double(this.getProjection().getDevice2D().getDeviceWidth(), deviceBaseLine.getY()), axisBaseLineColor);
    }

    protected void paintMetricsY(View v2d, Graphics2D g2d, List<Metrics> metricsY, double baseLine, int offsetPixel) {
        Point2D deviceBaseLine = this.getProjection().userToPixel(new Point2D.Double(baseLine, 0.0));
        for (Metrics m : metricsY) {
            Point2D.Double p = new Point2D.Double();
            p = new Point2D.Double(deviceBaseLine.getX(), m.getDeviceValue());
            m.setMarkerLocation(p);
            if (Metrics.MarkerPosition.isYCompatible(this.deviceMarkerPosition)) {
                m.setMarkerPosition(this.deviceMarkerPosition);
                continue;
            }
            m.setMarkerPosition(Metrics.MarkerPosition.W);
        }
        this.getMetricsPainter().doPaintMetrics(g2d, metricsY);
    }

    protected void paintMetricsYBaseLine(View view, Graphics2D g2d, double baseLine) {
        Point2D deviceBaseLine = this.getProjection().userToPixel(new Point2D.Double(baseLine, 0.0));
        Color axisBaseLineColor = this.getBaseLineColor() != null ? this.getBaseLineColor() : this.getProjection().getThemeColor();
        this.getMetricsPainter().doPaintLineMetrics(g2d, new Point2D.Double(deviceBaseLine.getX(), 0.0), new Point2D.Double(deviceBaseLine.getX(), this.getProjection().getDevice2D().getDeviceHeight()), axisBaseLineColor);
    }

    protected void paintMetrics(View v2d, Graphics2D g2d, ViewPart viewPart) {
        if (!this.isAccessible(viewPart)) {
            return;
        }
        this.assignType();
        List<Metrics> metrics = this.getMetricsManager().getDeviceMetrics();
        if (this.deviceAxis == DeviceAxis.AxisX) {
            this.paintMetricsX(v2d, g2d, metrics, this.baseLine, 0);
            if (this.isBaseLinePaint()) {
                this.paintMetricsXBaseLine(v2d, g2d, this.baseLine);
            }
        }
        if (this.deviceAxis == DeviceAxis.AxisY) {
            this.paintMetricsY(v2d, g2d, metrics, this.baseLine, 0);
            if (this.isBaseLinePaint()) {
                this.paintMetricsYBaseLine(v2d, g2d, this.baseLine);
            }
        }
    }

    @Override
    public final void paintPlugin(View view, Graphics2D g2d, ViewPart viewPart) {
        this.paintMetrics(view, g2d, viewPart);
    }

    public static class DeviceModeledMetrics
    extends DeviceMetricsPlugin<ModeledMetricsManager> {
        public DeviceModeledMetrics(double baseLine, DeviceAxis deviceAxis) {
            super(new ModeledMetricsManager(), baseLine, deviceAxis);
        }

        public DeviceModeledMetrics(double baseLine, Metrics.MarkerPosition deviceMarkerPosition, DeviceAxis deviceAxis) {
            super(new ModeledMetricsManager(), baseLine, deviceMarkerPosition, deviceAxis);
        }

        public List<ModeledMetricsManager.MetricsModel> getMetricsModels() {
            return ((ModeledMetricsManager)this.getMetricsManager()).getMetricsModels();
        }

        public static class Y
        extends DeviceModeledMetrics {
            public Y(double baseLine) {
                super(baseLine, DeviceAxis.AxisY);
            }

            public Y(double baseLine, Metrics.MarkerPosition markerPosition) {
                super(baseLine, markerPosition, DeviceAxis.AxisY);
            }
        }

        public static class X
        extends DeviceModeledMetrics {
            public X(double baseLine) {
                super(baseLine, DeviceAxis.AxisX);
            }

            public X(double baseLine, Metrics.MarkerPosition markerPosition) {
                super(baseLine, markerPosition, DeviceAxis.AxisX);
            }
        }
    }

    public static class DeviceTimeMetrics
    extends DeviceMetricsPlugin<TimeMetricsManager> {
        public DeviceTimeMetrics(double baseLine, DeviceAxis deviceAxis) {
            super(new TimeMetricsManager(), baseLine, deviceAxis);
            this.setName(AxisMetricsPlugin.TimeMetrics.class.getCanonicalName());
        }

        public DeviceTimeMetrics(double baseLine, Metrics.MarkerPosition markerPosition, DeviceAxis deviceAxis) {
            super(new TimeMetricsManager(), baseLine, markerPosition, deviceAxis);
            this.setName(AxisMetricsPlugin.TimeMetrics.class.getCanonicalName());
        }

        public void registerTimeModel(TimeMetricsManager.TimeModel model) {
            ((TimeMetricsManager)this.getMetricsManager()).registerTimingModel(model);
        }

        public void registerTimeModels(TimeMetricsManager.TimeModel ... models) {
            ((TimeMetricsManager)this.getMetricsManager()).registerTimingModels(models);
        }

        public void unregisterTimeModel(TimeMetricsManager.TimeModel model) {
            ((TimeMetricsManager)this.getMetricsManager()).unregisterTimingModel(model);
        }

        public void unregisterTimeModels(TimeMetricsManager.TimeModel ... models) {
            ((TimeMetricsManager)this.getMetricsManager()).unregisterTimingModels(models);
        }

        public List<TimeMetricsManager.TimeModel> getTimingModels() {
            return ((TimeMetricsManager)this.getMetricsManager()).getTimingModels();
        }

        @Override
        protected void paintMetrics(View v2d, Graphics2D g2d, ViewPart viewPart) {
            if (!((DeviceMetricsPlugin)this).isAccessible(viewPart)) {
                return;
            }
            ((DeviceMetricsPlugin)this).assignType();
            int axisSpacing = 0;
            List<TimeMetricsManager.TimeModel> sequence = ((TimeMetricsManager)this.getMetricsManager()).getTimingSequence();
            for (TimeMetricsManager.TimeModel timingManager : sequence) {
                axisSpacing += timingManager.getPixelAxisHolder();
            }
        }

        public static class Y
        extends DeviceTimeMetrics {
            public Y(double baseLine) {
                super(baseLine, DeviceAxis.AxisY);
            }

            public Y(double baseLine, Metrics.MarkerPosition markerPosition) {
                super(baseLine, markerPosition, DeviceAxis.AxisY);
            }
        }

        public static class X
        extends DeviceTimeMetrics {
            public X(double baseLine) {
                super(baseLine, DeviceAxis.AxisX);
            }

            public X(double baseLine, Metrics.MarkerPosition markerPosition) {
                super(baseLine, markerPosition, DeviceAxis.AxisX);
            }
        }
    }

    public static class DeviceFlowMetrics
    extends DeviceMetricsPlugin<FlowMetricsManager> {
        public DeviceFlowMetrics(double flowStart, double flowEnd, double flowInterval, double baseLine, DeviceAxis deviceAxis) {
            super(new FlowMetricsManager(flowStart, flowEnd, flowInterval), baseLine, deviceAxis);
        }

        public DeviceFlowMetrics(double flowStart, double flowEnd, double flowInterval, double baseLine, Metrics.MarkerPosition markerPosition, DeviceAxis deviceAxis) {
            super(new FlowMetricsManager(flowStart, flowEnd, flowInterval), baseLine, markerPosition, deviceAxis);
            super.setName(DeviceFlowMetrics.class.getCanonicalName());
        }

        public static class Y
        extends DeviceFlowMetrics {
            public Y(double flowStart, double flowEnd, double flowInterval, double baseLine) {
                super(flowStart, flowEnd, flowInterval, baseLine, DeviceAxis.AxisY);
            }

            public Y(double flowStart, double flowEnd, double flowInterval, double baseLine, Metrics.MarkerPosition markerPosition) {
                super(flowStart, flowEnd, flowInterval, baseLine, markerPosition, DeviceAxis.AxisY);
            }
        }

        public static class X
        extends DeviceFlowMetrics {
            public X(double flowStart, double flowEnd, double flowInterval, double baseLine) {
                super(flowStart, flowEnd, flowInterval, baseLine, DeviceAxis.AxisX);
            }

            public X(double flowStart, double flowEnd, double flowInterval, double baseLine, Metrics.MarkerPosition markerPosition) {
                super(flowStart, flowEnd, flowInterval, baseLine, markerPosition, DeviceAxis.AxisX);
            }
        }
    }

    public static class DeviceFreeMetrics
    extends DeviceMetricsPlugin<FreeMetricsManager> {
        public DeviceFreeMetrics(double baseLine, DeviceAxis deviceAxis) {
            super(new FreeMetricsManager(), baseLine, deviceAxis);
        }

        public DeviceFreeMetrics(double baseLine, Metrics.MarkerPosition markerPosition, DeviceAxis deviceAxis) {
            super(new FreeMetricsManager(), baseLine, deviceAxis);
        }

        public void addMetrics(double m) {
            ((FreeMetricsManager)this.getMetricsManager()).addMetrics(m);
        }

        public void addMetrics(double m, String symbol) {
            ((FreeMetricsManager)this.getMetricsManager()).addMetrics(m, symbol);
        }

        public static class Y
        extends DeviceFreeMetrics {
            public Y(double baseLine) {
                super(baseLine, DeviceAxis.AxisY);
            }

            public Y(double baseLine, Metrics.MarkerPosition markerPosition) {
                super(baseLine, markerPosition, DeviceAxis.AxisY);
            }
        }

        public static class X
        extends DeviceFreeMetrics {
            public X(double baseLine) {
                super(baseLine, DeviceAxis.AxisX);
            }

            public X(double baseLine, Metrics.MarkerPosition markerPosition) {
                super(baseLine, markerPosition, DeviceAxis.AxisX);
            }
        }
    }

    public static class DeviceStaticMetrics
    extends DeviceMetricsPlugin<StaticMetricsManager> {
        public DeviceStaticMetrics(int metricsCount, double baseLine, DeviceAxis deviceAxis) {
            super(new StaticMetricsManager(metricsCount), baseLine, deviceAxis);
        }

        public DeviceStaticMetrics(int metricsCount, double baseLine, Metrics.MarkerPosition markerPosition, DeviceAxis deviceAxis) {
            super(new StaticMetricsManager(metricsCount), baseLine, markerPosition, deviceAxis);
        }

        @Override
        public StaticMetricsManager getMetricsManager() {
            return (StaticMetricsManager)super.getMetricsManager();
        }

        public static class Y
        extends DeviceStaticMetrics {
            public Y(int metricsCount, double baseLine) {
                super(metricsCount, baseLine, DeviceAxis.AxisY);
            }

            public Y(int metricsCount, double baseLine, Metrics.MarkerPosition markerPosition) {
                super(metricsCount, baseLine, markerPosition, DeviceAxis.AxisY);
            }
        }

        public static class X
        extends DeviceStaticMetrics {
            public X(int metricsCount, double baseLine) {
                super(metricsCount, baseLine, DeviceAxis.AxisX);
            }

            public X(int metricsCount, double baseLine, Metrics.MarkerPosition markerPosition) {
                super(metricsCount, baseLine, markerPosition, DeviceAxis.AxisX);
            }
        }
    }

    public static enum DeviceAxis {
        AxisX,
        AxisY;

    }
}

