/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.metrics;

import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.math.BigDecimal;
import java.util.Comparator;
import org.jensoft.core.plugin.metrics.format.IMetricsFormat;

public class Metrics {
    private MetricsType metricsType;
    private double deviceValue;
    private BigDecimal userValueAsBigDecimal;
    private double userValue;
    private Color metricsMarkerColor;
    private Stroke metricsMarkerStroke;
    private Color metricsLabelColor;
    private IMetricsFormat format;
    private Font font;
    private String metricsLabel;
    private MetricsNature nature = MetricsNature.Major;
    private Point2D markerLocation;
    private MarkerPosition markerPosition;
    private boolean lockMarker = true;
    private boolean lockLabel = true;
    private boolean visible = true;
    public static MetricsComparator metricsComparator;

    public Metrics() {
    }

    public Metrics(MetricsType type) {
        this.metricsType = type;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public String toString() {
        return "Metrics [metricsType=" + (Object)((Object)this.metricsType) + ", deviceValue=" + this.deviceValue + ", userValue=" + this.userValue + ", format=" + this.format + ", metricsLabel=" + this.metricsLabel + ", nature=" + (Object)((Object)this.nature) + ", visible=" + this.visible + "]";
    }

    public boolean isLockMarker() {
        return this.lockMarker;
    }

    public void setLockMarker(boolean lockMarker) {
        this.lockMarker = lockMarker;
    }

    public boolean isLockLabel() {
        return this.lockLabel;
    }

    public void setLockLabel(boolean lockLabel) {
        this.lockLabel = lockLabel;
    }

    public MarkerPosition getMarkerPosition() {
        return this.markerPosition;
    }

    public void setMarkerPosition(MarkerPosition markerPosition) {
        this.markerPosition = markerPosition;
    }

    public Point2D getMarkerLocation() {
        return this.markerLocation;
    }

    public void setMarkerLocation(Point2D markerLocation) {
        this.markerLocation = markerLocation;
    }

    public MetricsNature getNature() {
        return this.nature;
    }

    public void setNature(MetricsNature nature) {
        this.nature = nature;
    }

    public MetricsType getMetricsType() {
        return this.metricsType;
    }

    public void setMetricsType(MetricsType metricsType) {
        this.metricsType = metricsType;
    }

    public Color getMetricsMarkerColor() {
        return this.metricsMarkerColor;
    }

    public void setMetricsMarkerColor(Color metricsMarkerColor) {
        this.metricsMarkerColor = metricsMarkerColor;
    }

    public Stroke getMetricsMarkerStroke() {
        return this.metricsMarkerStroke;
    }

    public void setMetricsMarkerStroke(Stroke metricsMarkerStroke) {
        this.metricsMarkerStroke = metricsMarkerStroke;
    }

    public double getDeviceValue() {
        return this.deviceValue;
    }

    public void setDeviceValue(double metricsValue) {
        this.deviceValue = metricsValue;
    }

    public double getUserValue() {
        return this.userValue;
    }

    public void setUserValue(double userValue) {
        this.userValue = userValue;
    }

    public Color getMetricsLabelColor() {
        return this.metricsLabelColor;
    }

    public void setMetricsLabelColor(Color metricsLabelColor) {
        this.metricsLabelColor = metricsLabelColor;
    }

    public IMetricsFormat getFormat() {
        return this.format;
    }

    public void setFormat(IMetricsFormat format) {
        this.format = format;
    }

    public String getMetricsLabel() {
        return this.metricsLabel;
    }

    public void setMetricsLabel(String metricsLabel) {
        this.metricsLabel = metricsLabel;
    }

    public static MetricsComparator getComparator() {
        if (metricsComparator == null) {
            metricsComparator = new MetricsComparator();
        }
        return metricsComparator;
    }

    public BigDecimal getUserValueAsBigDecimal() {
        return this.userValueAsBigDecimal;
    }

    public void setUserValueAsBigDecimal(BigDecimal userValueAsBigDecimal) {
        this.userValueAsBigDecimal = userValueAsBigDecimal;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public static class MetricsComparator
    implements Comparator<Metrics> {
        @Override
        public int compare(Metrics d1, Metrics d2) {
            if (d1.getUserValue() > d2.getUserValue()) {
                return 1;
            }
            if (d1.getUserValue() < d2.getUserValue()) {
                return -1;
            }
            return 0;
        }
    }

    public static enum MarkerPosition {
        N,
        S,
        W,
        E;


        public static boolean isXCompatible(MarkerPosition marker) {
            return marker != null && (marker == N || marker == S);
        }

        public static boolean isYCompatible(MarkerPosition marker) {
            return marker != null && (marker == W || marker == E);
        }
    }

    public static enum MetricsNature {
        Minor,
        Median,
        Major;

    }

    public static enum MetricsType {
        XMetrics,
        YMetrics;

    }

    public static enum Gravity {
        Natural,
        Rotate;

    }
}

