/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.metrics.manager;

import java.awt.geom.Point2D;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.metrics.Metrics;
import org.jensoft.core.plugin.metrics.manager.AbstractMetricsManager;
import org.jensoft.core.projection.Projection;

public class FlowMetricsManager
extends AbstractMetricsManager {
    private double flowInterval = 0.0;
    private double flowStart = 0.0;
    private double flowEnd = 0.0;
    private List<Metrics> deviceMetrics = new ArrayList<Metrics>();

    public FlowMetricsManager(double flowStart, double flowEnd, double flowInterval) {
        this.flowStart = flowStart;
        this.flowEnd = flowEnd;
        this.flowInterval = flowInterval;
    }

    public double getFlowInterval() {
        return this.flowInterval;
    }

    public void setFlowInterval(double flowInterval) {
        this.flowInterval = flowInterval;
    }

    public double getFlowStart() {
        return this.flowStart;
    }

    public void setFlowStart(double flowStart) {
        this.flowStart = flowStart;
    }

    public double getFlowEnd() {
        return this.flowEnd;
    }

    public void setFlowEnd(double flowEnd) {
        this.flowEnd = flowEnd;
    }

    protected String format(BigDecimal value) {
        if (this.getMetricsPlugin().getFormat() != null) {
            return this.getMetricsPlugin().getFormat().format(value.doubleValue());
        }
        DecimalFormat formater = null;
        formater = this.getMetricsPlugin().getLocale() != null ? (DecimalFormat)NumberFormat.getInstance(this.getMetricsPlugin().getLocale()) : new DecimalFormat();
        if (this.getMetricsPlugin().getSuffix() != null) {
            return formater.format(value.doubleValue()) + this.getMetricsPlugin().getSuffix();
        }
        return formater.format(value.doubleValue());
    }

    @Override
    public List<Metrics> getDeviceMetrics() {
        this.deviceMetrics.clear();
        Projection projection = this.getMetricsPlugin().getProjection();
        if (this.flowEnd <= this.flowStart) {
            throw new IllegalArgumentException("metrics flow end should be greater than metrics flow start");
        }
        BigDecimal start = new BigDecimal(this.flowStart + "");
        BigDecimal end = new BigDecimal(this.flowEnd + "");
        BigDecimal interval = new BigDecimal(this.flowInterval + "");
        boolean flag = true;
        int count = 0;
        while (flag) {
            Point2D p2dDevice;
            Point2D.Double p2dUser;
            BigDecimal increment = new BigDecimal(count);
            BigDecimal m = start.add(increment.multiply(interval));
            Metrics metrics = null;
            if (this.getType() == Metrics.MetricsType.XMetrics) {
                p2dUser = new Point2D.Double(m.doubleValue(), 0.0);
                p2dDevice = projection.userToPixel(p2dUser);
                metrics = new Metrics(Metrics.MetricsType.XMetrics);
                metrics.setDeviceValue(p2dDevice.getX());
                metrics.setUserValue(m.doubleValue());
                metrics.setUserValueAsBigDecimal(m);
                metrics.setMetricsLabel(this.format(m));
                if (m.doubleValue() >= projection.getMinX() && m.doubleValue() <= projection.getMaxX()) {
                    this.deviceMetrics.add(metrics);
                }
            } else if (this.getType() == Metrics.MetricsType.YMetrics) {
                p2dUser = new Point2D.Double(0.0, m.doubleValue());
                p2dDevice = projection.userToPixel(p2dUser);
                metrics = new Metrics(Metrics.MetricsType.YMetrics);
                metrics.setDeviceValue(p2dDevice.getY());
                metrics.setUserValue(m.doubleValue());
                metrics.setUserValueAsBigDecimal(m);
                metrics.setMetricsLabel(this.format(m));
                if (m.doubleValue() >= projection.getMinY() && m.doubleValue() <= projection.getMaxY()) {
                    this.deviceMetrics.add(metrics);
                }
            }
            if (m.doubleValue() > end.doubleValue()) {
                flag = false;
            }
            ++count;
        }
        return this.deviceMetrics;
    }
}

