/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.metrics.manager;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.metrics.Metrics;
import org.jensoft.core.plugin.metrics.manager.AbstractMetricsManager;
import org.jensoft.core.projection.Projection;

public class FreeMetricsManager
extends AbstractMetricsManager {
    private List<Metrics> metricsDevice = new ArrayList<Metrics>();
    private List<metricsTemp> volatileMetrics = new ArrayList<metricsTemp>();

    public void addMetrics(double metricsValue) {
        this.volatileMetrics.add(new metricsTemp(metricsValue, null));
    }

    public void addMetrics(double m, String label) {
        this.volatileMetrics.add(new metricsTemp(m, label));
    }

    @Override
    public List<Metrics> getDeviceMetrics() {
        block11: {
            Projection w2d;
            block10: {
                this.metricsDevice.clear();
                w2d = this.getMetricsPlugin().getProjection();
                if (this.getType() != Metrics.MetricsType.XMetrics) break block10;
                for (int i = 0; i < this.volatileMetrics.size(); ++i) {
                    metricsTemp tTemp = this.volatileMetrics.get(i);
                    double userMetricsX = tTemp.value;
                    if (!(userMetricsX > w2d.getMinX()) || !(userMetricsX < w2d.getMaxX())) continue;
                    Point2D.Double p2dUserMetrics = new Point2D.Double(userMetricsX, 0.0);
                    Point2D p2dDeviceMetrics = w2d.userToPixel(p2dUserMetrics);
                    Metrics metrics = new Metrics(Metrics.MetricsType.XMetrics);
                    metrics.setDeviceValue(p2dDeviceMetrics.getX());
                    metrics.setUserValue(userMetricsX);
                    if (tTemp.label != null) {
                        metrics.setMetricsLabel(tTemp.label);
                    } else if (this.getMetricsFormat() == null) {
                        metrics.setMetricsLabel(this.getDefaultFormat().format(userMetricsX));
                    } else {
                        metrics.setMetricsLabel(this.getMetricsFormat().format(userMetricsX));
                    }
                    this.metricsDevice.add(metrics);
                }
                break block11;
            }
            if (this.getType() != Metrics.MetricsType.YMetrics) break block11;
            for (int i = 0; i < this.volatileMetrics.size(); ++i) {
                metricsTemp tTemp = this.volatileMetrics.get(i);
                double userMetricsY = tTemp.value;
                if (!(userMetricsY > w2d.getMinY()) || !(userMetricsY < w2d.getMaxY())) continue;
                Point2D.Double p2dUserMetrics = new Point2D.Double(0.0, userMetricsY);
                Point2D p2dDeviceMetrics = w2d.userToPixel(p2dUserMetrics);
                Metrics metrics = new Metrics(Metrics.MetricsType.YMetrics);
                metrics.setDeviceValue(p2dDeviceMetrics.getY());
                metrics.setUserValue(userMetricsY);
                if (tTemp.label != null) {
                    metrics.setMetricsLabel(tTemp.label);
                } else if (this.getMetricsFormat() == null) {
                    metrics.setMetricsLabel(this.getDefaultFormat().format(userMetricsY));
                } else {
                    metrics.setMetricsLabel(this.getMetricsFormat().format(userMetricsY));
                }
                this.metricsDevice.add(metrics);
            }
        }
        return this.metricsDevice;
    }

    class metricsTemp {
        double value;
        String label;

        public metricsTemp(double v, String label) {
            this.value = v;
            this.label = label;
        }
    }
}

