/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.metrics.manager;

import java.awt.Color;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.jensoft.core.plugin.metrics.Metrics;
import org.jensoft.core.plugin.metrics.manager.AbstractMetricsManager;
import org.jensoft.core.projection.Projection;

public class ModeledMetricsManager
extends AbstractMetricsManager {
    private List<MetricsModel> metricsModels;
    private MetricsModelComparator modelComparator = new MetricsModelComparator();
    private boolean medianMetricsOption = true;
    private double medianMetricsDensityThreshold = 50.0;
    private boolean minorMetricsOption = true;
    private double minorMetricsDensityThreshold = 80.0;
    private int intervalDensity = 3;

    public ModeledMetricsManager() {
        this.metricsModels = new ArrayList<MetricsModel>();
    }

    public void applyLocalizedMetrics(Locale locale) {
        this.metricsModels.clear();
        List<MetricsModel> models = this.createDefaultRangeExponentModel(24);
        this.metricsModels.addAll(models);
        Collections.sort(this.metricsModels, this.modelComparator);
    }

    public boolean isMedianMetricsOption() {
        return this.medianMetricsOption;
    }

    public void setMedianMetricsOption(boolean medianMetricsOption) {
        this.medianMetricsOption = medianMetricsOption;
    }

    public double getMedianMetricsDensityThreshold() {
        return this.medianMetricsDensityThreshold;
    }

    public void setMedianMetricsDensityThreshold(double medianMetricsDensityThreshold) {
        this.medianMetricsDensityThreshold = medianMetricsDensityThreshold;
    }

    public boolean isMinorMetricsOption() {
        return this.minorMetricsOption;
    }

    public void setMinorMetricsOption(boolean minorMetricsOption) {
        this.minorMetricsOption = minorMetricsOption;
    }

    public double getMinorMetricsDensityThreshold() {
        return this.minorMetricsDensityThreshold;
    }

    public void setMinorMetricsDensityThreshold(double minorMetricsDensityThreshold) {
        this.minorMetricsDensityThreshold = minorMetricsDensityThreshold;
    }

    public int getIntervalDensity() {
        return this.intervalDensity;
    }

    public void setIntervalDensity(int intervalDensity) {
        this.intervalDensity = intervalDensity;
    }

    protected List<MetricsModel> createDefaultRangeExponentModel(int exponentLimit) {
        ArrayList<MetricsModel> models = new ArrayList<MetricsModel>();
        int exp = exponentLimit;
        for (int i = -Math.abs(exp); i <= Math.abs(exp); ++i) {
            MetricsModel model = this.createModel(i);
            model.setMetricsManager(this);
            models.add(model);
        }
        return models;
    }

    protected MetricsModel createModel(int exponent) {
        return ModeledMetricsManager.createDefaultExponentModel(exponent, this.getMetricsPlugin().getLocale());
    }

    public static MetricsModel createDefaultExponentModel(int exp, Locale locale) {
        MetricsModel model = null;
        StringBuffer buffer = new StringBuffer();
        if (exp < 0) {
            buffer.append("0.");
            for (int j = 1; j < Math.abs(exp); ++j) {
                buffer.append("0");
            }
            buffer.append("1");
            String multiplier = buffer.toString();
            DecimalFormat formater = (DecimalFormat)NumberFormat.getInstance(locale);
            formater.setMinimumFractionDigits(Math.abs(exp));
            formater.setMaximumFractionDigits(Math.abs(exp));
            model = new MetricsModel(exp, new BigDecimal(multiplier), formater);
        } else if (exp > 0) {
            buffer.append("1");
            for (int j = 1; j <= Math.abs(exp); ++j) {
                buffer.append("0");
            }
            String multiplier = buffer.toString();
            DecimalFormat formater = (DecimalFormat)NumberFormat.getInstance(locale);
            model = new MetricsModel(exp, new BigDecimal(multiplier), formater);
        } else if (exp == 0) {
            DecimalFormat formater = (DecimalFormat)NumberFormat.getInstance(locale);
            model = new MetricsModel(exp, new BigDecimal("1"), formater);
        }
        return model;
    }

    public List<MetricsModel> getMetricsModels() {
        return this.metricsModels;
    }

    protected Metrics generateMetrics(BigDecimal userValue, MetricsModel model) {
        Metrics metrics = new Metrics(this.getType());
        Projection proj = this.getMetricsPlugin().getProjection();
        double deviceValue = 0.0;
        double maxPixelValue = 0.0;
        if (this.getType() == Metrics.MetricsType.XMetrics) {
            deviceValue = proj.userToPixelX(userValue.doubleValue());
            maxPixelValue = proj.getPixelWidth();
        } else if (this.getType() == Metrics.MetricsType.YMetrics) {
            deviceValue = proj.userToPixelY(userValue.doubleValue());
            maxPixelValue = proj.getPixelHeight();
        }
        if (deviceValue < 0.0 || deviceValue > maxPixelValue) {
            return null;
        }
        metrics.setDeviceValue(deviceValue);
        metrics.setUserValueAsBigDecimal(userValue);
        metrics.setUserValue(userValue.doubleValue());
        if (this.getMetricsPlugin().getSuffix() == null) {
            metrics.setMetricsLabel(model.formatValue(userValue.doubleValue()));
        } else {
            metrics.setMetricsLabel(model.formatValue(userValue.doubleValue()) + this.getMetricsPlugin().getSuffix());
        }
        if (model != null) {
            if (model.getMetricsLabelColor() != null) {
                metrics.setMetricsLabelColor(model.getMetricsLabelColor());
            }
            if (model.getMetricsMarkerColor() != null) {
                metrics.setMetricsMarkerColor(model.getMetricsMarkerColor());
            }
        }
        return metrics;
    }

    private boolean exists(Metrics m, List<Metrics> metrics) {
        for (Metrics metrics2 : metrics) {
            if (m.getUserValueAsBigDecimal().compareTo(metrics2.getUserValueAsBigDecimal()) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public final List<Metrics> getDeviceMetrics() {
        if (this.metricsModels.isEmpty()) {
            List<MetricsModel> models = this.createDefaultRangeExponentModel(24);
            this.metricsModels.addAll(models);
            Collections.sort(this.metricsModels, this.modelComparator);
        }
        ArrayList<Metrics> metrics = new ArrayList<Metrics>();
        for (int i = 0; i < this.metricsModels.size(); ++i) {
            MetricsModel model = this.metricsModels.get(i);
            model.solve();
            boolean valid = model.isValid();
            if (!valid) continue;
            double density = model.getDensity();
            List<Metrics> majors = model.generateMajorMetrics();
            metrics.addAll(majors);
            if (this.isMedianMetricsOption() && density < this.getMedianMetricsDensityThreshold()) {
                List<Metrics> medians = model.generateMedianMetrics();
                for (Metrics median : medians) {
                    if (this.exists(median, metrics)) continue;
                    metrics.add(median);
                }
            }
            if (this.isMinorMetricsOption() && density < this.getMinorMetricsDensityThreshold()) {
                List<Metrics> minors = model.generateMinorMetrics();
                for (Metrics minor : minors) {
                    if (this.exists(minor, metrics)) continue;
                    metrics.add(minor);
                }
            }
            return metrics;
        }
        return metrics;
    }

    public static class MetricsModel {
        private ModeledMetricsManager metricsManager;
        private DecimalFormat decimalFormat = new DecimalFormat();
        private int exponent;
        private BigDecimal factor;
        private BigDecimal userSize;
        private BigDecimal pixelSize;
        private BigDecimal ref;
        private BigDecimal maxValue;
        private double pixelLabelHolder;
        private Color metricsLabelColor;
        private Color metricsMarkerColor;

        public MetricsModel(int exponent, BigDecimal factor) {
            this.exponent = exponent;
            this.factor = factor;
        }

        public MetricsModel(int exponent, BigDecimal factor, DecimalFormat format) {
            this.exponent = exponent;
            this.factor = factor;
            this.decimalFormat = format;
        }

        public MetricsModel nextModel() {
            MetricsModel mm = ModeledMetricsManager.createDefaultExponentModel(this.exponent + 1, this.getMetricsManager().getMetricsPlugin().getLocale());
            mm.setMetricsManager(this.metricsManager);
            return mm;
        }

        public MetricsModel previousModel() {
            MetricsModel mm = ModeledMetricsManager.createDefaultExponentModel(this.exponent - 1, this.getMetricsManager().getMetricsPlugin().getLocale());
            mm.setMetricsManager(this.metricsManager);
            return mm;
        }

        public void solve() {
            Projection proj = this.getMetricsManager().getMetricsPlugin().getProjection();
            int metricsSize = this.metricsManager.getMetricsPlugin().getMajorTextFont().getSize();
            if (this.getMetricsManager().getType() == Metrics.MetricsType.XMetrics) {
                this.userSize = new BigDecimal(proj.getUserWidth());
                BigDecimal bd1 = new BigDecimal(proj.getMinX()).divide(this.factor, RoundingMode.CEILING);
                BigInteger bi1 = bd1.toBigInteger();
                this.ref = new BigDecimal(bi1).multiply(this.getFactor());
                this.ref = this.ref.subtract(this.getFactor());
                if (this.ref.equals(new BigDecimal("0"))) {
                    this.ref = this.ref.subtract(this.factor);
                }
                this.pixelSize = new BigDecimal(proj.getPixelWidth());
                this.maxValue = new BigDecimal(proj.getMaxX());
                if (this.getMetricsManager().getMetricsPlugin().getGravity() == Metrics.Gravity.Rotate) {
                    this.pixelLabelHolder = 0.8 * (double)metricsSize + (double)this.metricsManager.getIntervalDensity();
                } else {
                    int s = this.formatValue(this.ref.doubleValue()).length();
                    if (this.getMetricsManager().getMetricsPlugin().getSuffix() != null) {
                        s = (this.formatValue(this.ref.doubleValue()) + this.getMetricsManager().getMetricsPlugin().getSuffix()).length();
                    }
                    this.pixelLabelHolder = 0.8 * (double)s * (double)metricsSize + (double)this.metricsManager.getIntervalDensity();
                }
            } else if (this.getMetricsManager().getType() == Metrics.MetricsType.YMetrics) {
                this.userSize = new BigDecimal(proj.getUserHeight());
                BigDecimal bd1 = new BigDecimal(proj.getMinY()).divide(this.factor, RoundingMode.CEILING);
                BigInteger bi1 = bd1.toBigInteger();
                this.ref = new BigDecimal(bi1).multiply(this.getFactor());
                this.ref = this.ref.subtract(this.getFactor());
                if (this.ref.equals(new BigDecimal("0"))) {
                    this.ref = this.ref.subtract(this.factor);
                }
                this.pixelSize = new BigDecimal(proj.getPixelHeight());
                this.maxValue = new BigDecimal(proj.getMaxY());
                if (this.getMetricsManager().getMetricsPlugin().getGravity() == Metrics.Gravity.Rotate) {
                    int s = this.formatValue(this.ref.doubleValue()).length();
                    if (this.getMetricsManager().getMetricsPlugin().getSuffix() != null) {
                        s = (this.formatValue(this.ref.doubleValue()) + this.getMetricsManager().getMetricsPlugin().getSuffix()).length();
                    }
                    this.pixelLabelHolder = 0.8 * (double)s * (double)metricsSize + (double)this.metricsManager.getIntervalDensity();
                } else {
                    this.pixelLabelHolder = 0.8 * (double)metricsSize + (double)this.metricsManager.getIntervalDensity();
                }
            }
        }

        public double getDensity() {
            int s = this.ref.toString().length();
            int metricsSize = this.metricsManager.getMetricsPlugin().getMajorTextFont().getSize();
            double commonHolder = 0.8 * (double)s * (double)metricsSize + (double)this.metricsManager.getIntervalDensity();
            double commonSize = this.userSize.divide(this.factor, RoundingMode.HALF_EVEN).multiply(new BigDecimal(commonHolder)).doubleValue();
            return commonSize * 100.0 / this.pixelSize.doubleValue();
        }

        public boolean isValid() {
            int compare = this.userSize.divide(this.factor, RoundingMode.HALF_EVEN).multiply(new BigDecimal(this.getPixelLabelHolder())).compareTo(this.pixelSize);
            return compare == -1;
        }

        protected String formatValue(double value) {
            return this.decimalFormat.format(value);
        }

        public List<Metrics> generateMedianMetrics() {
            DecimalFormat medianFormater = (DecimalFormat)NumberFormat.getInstance(this.metricsManager.getMetricsPlugin().getLocale());
            if (this.exponent < 0) {
                medianFormater.setMaximumFractionDigits(Math.abs(this.exponent) + 1);
                medianFormater.setMinimumFractionDigits(Math.abs(this.exponent) + 1);
            }
            BigDecimal seed = this.factor.multiply(new BigDecimal("0.5"));
            List<Metrics> metrics = this.generateMetrics(seed, Metrics.MetricsNature.Median);
            for (Metrics median : metrics) {
                String s = this.getMetricsManager().getMetricsPlugin().getSuffix();
                if (s != null) {
                    median.setMetricsLabel(medianFormater.format(median.getUserValue()) + s);
                    continue;
                }
                median.setMetricsLabel(medianFormater.format(median.getUserValue()));
            }
            return metrics;
        }

        public List<Metrics> generateMinorMetrics() {
            BigDecimal seed = this.factor.multiply(new BigDecimal("0.1"));
            List<Metrics> metrics = this.generateMetrics(seed, Metrics.MetricsNature.Minor);
            for (Metrics metrics2 : metrics) {
                metrics2.setMetricsLabel(null);
            }
            return metrics;
        }

        public List<Metrics> generateMajorMetrics() {
            return this.generateMetrics(this.factor, Metrics.MetricsNature.Major);
        }

        private List<Metrics> generateMetrics(BigDecimal seed, Metrics.MetricsNature nature) {
            ArrayList<Metrics> metrics = new ArrayList<Metrics>();
            boolean flag = true;
            BigDecimal metricsValue = this.ref;
            Metrics m0 = this.getMetricsManager().generateMetrics(metricsValue, this);
            if (m0 != null) {
                m0.setNature(nature);
                metrics.add(m0);
            }
            while (flag) {
                metricsValue = metricsValue.add(seed);
                Metrics m = this.getMetricsManager().generateMetrics(metricsValue, this);
                if (m != null) {
                    m.setNature(nature);
                    metrics.add(m);
                }
                if (metricsValue.compareTo(this.maxValue) != 1) continue;
                flag = false;
            }
            return metrics;
        }

        public ModeledMetricsManager getMetricsManager() {
            return this.metricsManager;
        }

        public void setMetricsManager(ModeledMetricsManager metricsManager) {
            this.metricsManager = metricsManager;
        }

        public int getExponent() {
            return this.exponent;
        }

        public void setExponent(int exponent) {
            this.exponent = exponent;
        }

        public BigDecimal getRef() {
            return this.ref;
        }

        public void setRef(BigDecimal ref) {
            this.ref = ref;
        }

        public BigDecimal getMaxValue() {
            return this.maxValue;
        }

        public void setMaxValue(BigDecimal maxValue) {
            this.maxValue = maxValue;
        }

        public DecimalFormat getDecimalFormat() {
            return this.decimalFormat;
        }

        public void setDecimalFormat(DecimalFormat decimalFormat) {
            this.decimalFormat = decimalFormat;
        }

        public BigDecimal getFactor() {
            return this.factor;
        }

        public double getPixelLabelHolder() {
            return this.pixelLabelHolder;
        }

        public void setPixelLabelHolder(double pixelLabelHolder) {
            this.pixelLabelHolder = pixelLabelHolder;
        }

        public Color getMetricsLabelColor() {
            return this.metricsLabelColor;
        }

        public void setMetricsLabelColor(Color metricsLabelColor) {
            this.metricsLabelColor = metricsLabelColor;
        }

        public Color getMetricsMarkerColor() {
            return this.metricsMarkerColor;
        }

        public void setMetricsMarkerColor(Color metricsMarkerColor) {
            this.metricsMarkerColor = metricsMarkerColor;
        }
    }

    public class MetricsModelComparator
    implements Comparator<MetricsModel> {
        @Override
        public int compare(MetricsModel m1, MetricsModel m2) {
            return m1.getFactor().compareTo(m2.getFactor());
        }
    }
}

