/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.metrics.manager;

import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.jensoft.core.plugin.metrics.Metrics;
import org.jensoft.core.plugin.metrics.manager.AbstractMetricsManager;
import org.jensoft.core.projection.Projection;

public class TimeMetricsManager
extends AbstractMetricsManager {
    private static long SECOND_MILLIS = 1000L;
    private static long MINUTE_MILLIS = SECOND_MILLIS * 60L;
    private static long HOUR_MILLIS = MINUTE_MILLIS * 60L;
    private static long DAY_MILLIS = HOUR_MILLIS * 24L;
    private static long WEEK_MILLIS = DAY_MILLIS * 7L;
    private static long MONTH_MILLIS = WEEK_MILLIS * 4L;
    public static SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
    public static SimpleDateFormat monthFormat = new SimpleDateFormat("MMM");
    public static SimpleDateFormat monthShortFormat = new SimpleDateFormat("MMM");
    public static SimpleDateFormat secondFormat = new SimpleDateFormat("ss");
    public static SimpleDateFormat minuteFormat = new SimpleDateFormat("mm ' m'");
    public static SimpleDateFormat hourFormat = new SimpleDateFormat("HH ' h'");
    public static SimpleDateFormat dayNumberFormat = new SimpleDateFormat("dd");
    public static SimpleDateFormat dayLabelFormat = new SimpleDateFormat("EEE, dd");
    public static SimpleDateFormat dayLongLabelFormat = new SimpleDateFormat("EEE, dd ,MMM");
    public static SimpleDateFormat weekFormat = new SimpleDateFormat("'W.' ww");
    private List<TimeModel> timingModels;
    private boolean createMinimal = true;
    private TimeModelComparator modelComparator = new TimeModelComparator();

    public TimeMetricsManager() {
        this.timingModels = new ArrayList<TimeModel>();
    }

    public TimeMetricsManager(TimeModel ... models) {
        this();
        this.registerTimingModels(models);
    }

    public TimeMetricsManager(List<TimeModel> models) {
        this();
        this.registerTimingModels(models);
    }

    @Override
    public List<Metrics> getDeviceMetrics() {
        return new ArrayList<Metrics>();
    }

    public void registerTimingModel(TimeModel model) {
        TimeModel clone = model.cloneModel();
        clone.setTimingManager(this);
        this.timingModels.add(clone);
        if (this.createMinimal) {
            TimeModel minimalModel = clone.cloneModel();
            minimalModel.setMinimal(true);
            minimalModel.setTimingManager(this);
            this.timingModels.add(minimalModel);
        }
        Collections.sort(this.timingModels, this.modelComparator);
    }

    public void registerTimingModels(TimeModel ... models) {
        for (int i = 0; i < models.length; ++i) {
            this.registerTimingModel(models[i]);
        }
    }

    public void registerTimingModels(List<TimeModel> models) {
        TimeModel[] ma = models.toArray(new TimeModel[models.size()]);
        this.registerTimingModels(ma);
    }

    public void unregisterTimingModel(TimeModel model) {
        this.timingModels.remove(model);
    }

    public void unregisterTimingModels(TimeModel ... models) {
        for (int i = 0; i < models.length; ++i) {
            this.unregisterTimingModel(models[i]);
        }
    }

    public void unregisterTimingModels(List<TimeModel> models) {
        TimeModel[] ma = models.toArray(new TimeModel[models.size()]);
        this.unregisterTimingModels(ma);
    }

    public List<TimeModel> getTimingModels() {
        return this.timingModels;
    }

    public List<TimeModel> getTimingSequence() {
        Projection.Time timeProjection = this.getTimingProjection();
        Collections.sort(this.timingModels, this.modelComparator);
        ArrayList<TimeModel> sequence = new ArrayList<TimeModel>();
        int rank = 0;
        for (TimeModel timingManager : this.timingModels) {
            long modelTimeMillis;
            long windowTimeMillis = timeProjection.durationMillis();
            if (windowTimeMillis / (modelTimeMillis = timingManager.getMillis()) * (long)timingManager.getPixelLabelHolder() >= (long)timeProjection.getTimeDurationPixel()) continue;
            timingManager.setRank(rank++);
            sequence.add(timingManager);
        }
        return sequence;
    }

    public Projection.Time getTimingProjection() {
        Projection proj = this.getMetricsPlugin().getProjection();
        if (proj instanceof Projection.Linear) {
            if (this.getType() == Metrics.MetricsType.XMetrics) {
                Projection.TimeX timeX = new Projection.TimeX(new Date(new Double(proj.getMinX()).longValue()), new Date(new Double(proj.getMaxX()).longValue()), proj.getMinY(), proj.getMaxY());
                timeX.setDevice2D(proj.getDevice2D());
                timeX.setView(proj.getView());
                return timeX;
            }
            if (this.getType() == Metrics.MetricsType.YMetrics) {
                Projection.TimeY timeY = new Projection.TimeY(proj.getMinX(), proj.getMaxX(), new Date(new Double(proj.getMinY()).longValue()), new Date(new Double(proj.getMaxY()).longValue()));
                timeY.setDevice2D(proj.getDevice2D());
                timeY.setView(proj.getView());
                return timeY;
            }
        }
        if (proj instanceof Projection.Time) {
            return (Projection.Time)proj;
        }
        return null;
    }

    protected TimePointMetrics generateMetricsPoint(Calendar time, TimeModel model) {
        TimePointMetrics metrics = new TimePointMetrics(this.getType());
        metrics.setTime(time.getTime());
        double userValue = new Long(time.getTimeInMillis()).doubleValue();
        Projection.Time timingWindow = this.getTimingProjection();
        double deviceValue = timingWindow.timeToPixel(time.getTime());
        double max = timingWindow.getTimeDurationPixel();
        if (deviceValue < 0.0 || deviceValue > max) {
            return null;
        }
        metrics.setDeviceValue(deviceValue);
        metrics.setUserValue(userValue);
        metrics.setLockLabel(this.isLockLabel());
        metrics.setLockMarker(this.isLockMarker());
        if (model.isMinimal()) {
            metrics.setNature(Metrics.MetricsNature.Minor);
        }
        if (model != null) {
            if (model.getMetricsLabelColor() != null) {
                metrics.setMetricsLabelColor(model.getMetricsLabelColor());
            }
            if (model.getMetricsMarkerColor() != null) {
                metrics.setMetricsMarkerColor(model.getMetricsMarkerColor());
            }
        }
        return metrics;
    }

    protected TimeDurationMetrics generateMetricsDuration(Calendar startTime, Calendar endTime, TimeModel model) {
        TimePointMetrics pointStart = this.generateMetricsPoint(startTime, model);
        TimePointMetrics pointEnd = this.generateMetricsPoint(endTime, model);
        long centerMillis = startTime.getTimeInMillis() + (endTime.getTimeInMillis() - startTime.getTimeInMillis()) / 2L;
        Calendar middleTime = Calendar.getInstance();
        middleTime.setTimeInMillis(centerMillis);
        TimeDurationMetrics durationMetrics = new TimeDurationMetrics(this.getType());
        double userValue = new Long(middleTime.getTimeInMillis()).doubleValue();
        Projection.Time timingWindow = this.getTimingProjection();
        double deviceValue = timingWindow.timeToPixel(middleTime.getTime());
        double max = timingWindow.getTimeDurationPixel();
        if (deviceValue < 0.0 || deviceValue > max) {
            return null;
        }
        durationMetrics.setDeviceValue(deviceValue);
        durationMetrics.setUserValue(userValue);
        durationMetrics.setMetricsStart(pointStart);
        durationMetrics.setMetricsEnd(pointEnd);
        durationMetrics.setTimeStart(startTime.getTime());
        durationMetrics.setTimeEnd(endTime.getTime());
        if (model != null) {
            if (model.getMetricsLabelColor() != null) {
                durationMetrics.setMetricsLabelColor(model.getMetricsLabelColor());
            }
            if (model.getMetricsMarkerColor() != null) {
                durationMetrics.setMetricsMarkerColor(model.getMetricsMarkerColor());
            }
        }
        return durationMetrics;
    }

    public List<Metrics> formatMetricsPoint(List<TimePointMetrics> points, SimpleDateFormat formater) {
        ArrayList<Metrics> metrics = new ArrayList<Metrics>();
        for (TimePointMetrics point : points) {
            point.setMetricsLabel(formater.format(point.getTime()));
            metrics.add(point);
        }
        return metrics;
    }

    protected List<TimePointMetrics> generateSecondsPoint(Calendar ref, long duration, int secondIncrement, TimeModel model) {
        ArrayList<TimePointMetrics> seconds = new ArrayList<TimePointMetrics>();
        for (int i = 0; i <= new Long(duration).intValue() + 1; i += secondIncrement) {
            Calendar c = (Calendar)ref.clone();
            c.set(ref.get(1), ref.get(2), ref.get(5), ref.get(11), ref.get(12), ref.get(13) + i);
            TimePointMetrics m = this.generateMetricsPoint(c, model);
            if (m == null) continue;
            seconds.add(m);
        }
        return seconds;
    }

    protected List<TimePointMetrics> generateMinutesPoint(Calendar ref, long durationMinutes, int minuteIncrement, TimeModel model) {
        ArrayList<TimePointMetrics> minutes = new ArrayList<TimePointMetrics>();
        int count = new Long(durationMinutes + 60L).intValue();
        for (int i = 0; i <= count; i += minuteIncrement) {
            Calendar c = (Calendar)ref.clone();
            c.set(ref.get(1), ref.get(2), ref.get(5), ref.get(11), ref.get(12) + i, 0);
            TimePointMetrics m = this.generateMetricsPoint(c, model);
            if (m == null) continue;
            minutes.add(m);
        }
        return minutes;
    }

    protected List<TimePointMetrics> generateHoursPoint(Calendar ref, long durationHours, int hoursIncrement, TimeModel model) {
        ArrayList<TimePointMetrics> hours = new ArrayList<TimePointMetrics>();
        for (int i = 0; i <= new Long(durationHours + 24L).intValue() + 1; i += hoursIncrement) {
            Calendar c = (Calendar)ref.clone();
            c.set(ref.get(1), ref.get(2), ref.get(5), ref.get(11) + i, ref.get(12), 0);
            TimePointMetrics m = this.generateMetricsPoint(c, model);
            if (m == null) continue;
            hours.add(m);
        }
        return hours;
    }

    protected List<TimePointMetrics> generateDaysPoint(Calendar ref, long durationDays, int daysIncrement, TimeModel model) {
        ArrayList<TimePointMetrics> days = new ArrayList<TimePointMetrics>();
        for (int i = 0; i <= new Long(durationDays + 31L).intValue() + 1; i += daysIncrement) {
            Calendar c = (Calendar)ref.clone();
            c.set(ref.get(1), ref.get(2), ref.get(5) + i, ref.get(11), 0, 0);
            TimePointMetrics m = this.generateMetricsPoint(c, model);
            if (m == null) continue;
            days.add(m);
        }
        return days;
    }

    protected List<TimePointMetrics> generateMonthsPoint(Calendar ref, long durationMonth, int monthsIncrement, TimeModel model) {
        ArrayList<TimePointMetrics> days = new ArrayList<TimePointMetrics>();
        for (int i = 0; i <= new Long(durationMonth + 12L).intValue() + 1; i += monthsIncrement) {
            Calendar c = (Calendar)ref.clone();
            c.set(ref.get(1), ref.get(2), ref.get(5), ref.get(11), ref.get(12), ref.get(13));
            c.add(2, i);
            TimePointMetrics m = this.generateMetricsPoint(c, model);
            if (m == null) continue;
            days.add(m);
        }
        return days;
    }

    public class TimeDurationMetrics
    extends TimingMetrics {
        private Date timeStart;
        private Date timeEnd;
        private Metrics metricsStart;
        private Metrics metricsEnd;

        public TimeDurationMetrics() {
        }

        public TimeDurationMetrics(Metrics.MetricsType type) {
            super(type);
        }

        public Metrics getMetricsStart() {
            return this.metricsStart;
        }

        public void setMetricsStart(Metrics metricsStart) {
            this.metricsStart = metricsStart;
        }

        public Metrics getMetricsEnd() {
            return this.metricsEnd;
        }

        public void setMetricsEnd(Metrics metricsEnd) {
            this.metricsEnd = metricsEnd;
        }

        public Date getTimeCenter() {
            long diff = this.timeEnd.getTime() - this.timeStart.getTime();
            long centerTime = this.timeStart.getTime() + diff / 2L;
            return new Date(centerTime);
        }

        public Date getTimeStart() {
            return this.timeStart;
        }

        public void setTimeStart(Date timeStart) {
            this.timeStart = timeStart;
        }

        public Date getTimeEnd() {
            return this.timeEnd;
        }

        public void setTimeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
        }
    }

    public class TimePointMetrics
    extends TimingMetrics {
        private Date time;

        public TimePointMetrics() {
        }

        public TimePointMetrics(Metrics.MetricsType type) {
            super(type);
        }

        public Date getTime() {
            return this.time;
        }

        public void setTime(Date time) {
            this.time = time;
        }
    }

    public static abstract class TimingMetrics
    extends Metrics {
        public TimingMetrics() {
        }

        public TimingMetrics(Metrics.MetricsType type) {
            super(type);
        }
    }

    public static class MonthDurationModel
    extends TimeModel {
        public MonthDurationModel() {
            super(MONTH_MILLIS, 80, "month familly", "one month duration", "month", 18);
        }

        public MonthDurationModel(Color themeColor) {
            this(themeColor, themeColor);
        }

        public MonthDurationModel(Color markerColor, Color labelColor) {
            this();
            this.setMetricsLabelColor(labelColor);
            this.setMetricsMarkerColor(markerColor);
        }

        @Override
        public TimeModel cloneModel() {
            MonthDurationModel clone = new MonthDurationModel();
            clone.setMinimal(this.isMinimal());
            clone.setMetricsMarkerColor(this.getMetricsMarkerColor());
            clone.setMetricsLabelColor(this.getMetricsLabelColor());
            return clone;
        }

        @Override
        public List<Metrics> generateMetrics() {
            Calendar cal = Calendar.getInstance();
            Projection.Time time = this.getTimingManager().getTimingProjection();
            cal.setTime(time.getMinDate());
            Calendar ref = (Calendar)cal.clone();
            ref.set(cal.get(1), cal.get(2), 0, 0, 0, 0);
            ref.set(5, 1);
            ArrayList<TimeDurationMetrics> monthsDuration = new ArrayList<TimeDurationMetrics>();
            List<TimePointMetrics> monthsPoints = this.getTimingManager().generateMonthsPoint(ref, time.durationMonth(), 1, this);
            for (TimePointMetrics point : monthsPoints) {
                Calendar firstDayInMonth = Calendar.getInstance();
                firstDayInMonth.setTime(point.getTime());
                int maxDay = firstDayInMonth.getActualMaximum(5);
                Calendar lastDayInMonth = (Calendar)firstDayInMonth.clone();
                lastDayInMonth.set(5, maxDay);
                TimeDurationMetrics duration = this.getTimingManager().generateMetricsDuration(firstDayInMonth, lastDayInMonth, this);
                if (duration == null) continue;
                monthsDuration.add(duration);
            }
            return this.formatMonthDuration(monthsDuration);
        }

        public List<Metrics> formatMonthDuration(List<TimeDurationMetrics> points) {
            ArrayList<Metrics> metrics = new ArrayList<Metrics>();
            for (TimeDurationMetrics point : points) {
                point.setMetricsLabel(monthFormat.format(point.getTimeCenter()) + " - " + yearFormat.format(point.getTimeCenter()));
                metrics.add(point);
            }
            return metrics;
        }
    }

    public static class MonthModel
    extends TimeModel {
        public MonthModel() {
            super(MONTH_MILLIS, 80, "month familly", "one month", "month", 18);
        }

        public MonthModel(Color themeColor) {
            this(themeColor, themeColor);
        }

        public MonthModel(Color markerColor, Color labelColor) {
            this();
            this.setMetricsLabelColor(labelColor);
            this.setMetricsMarkerColor(markerColor);
        }

        @Override
        public TimeModel cloneModel() {
            MonthModel clone = new MonthModel();
            clone.setMinimal(this.isMinimal());
            clone.setMetricsMarkerColor(this.getMetricsMarkerColor());
            clone.setMetricsLabelColor(this.getMetricsLabelColor());
            return clone;
        }

        @Override
        public List<Metrics> generateMetrics() {
            Calendar cal = Calendar.getInstance();
            Projection.Time time = this.getTimingManager().getTimingProjection();
            cal.setTime(time.getMinDate());
            Calendar ref = (Calendar)cal.clone();
            ref.set(cal.get(1), cal.get(2), 0, 0, 0, 0);
            List<TimePointMetrics> monthsPoints = this.getTimingManager().generateMonthsPoint(ref, time.durationMonth(), 1, this);
            return this.getTimingManager().formatMetricsPoint(monthsPoints, monthFormat);
        }
    }

    public static class WeekDurationDurationModel
    extends TimeModel {
        public WeekDurationDurationModel() {
            super(DAY_MILLIS * 7L, 80, "week familly", "one week duration", "week - 7 days", 18);
        }

        public WeekDurationDurationModel(Color themeColor) {
            this(themeColor, themeColor);
        }

        public WeekDurationDurationModel(Color markerColor, Color labelColor) {
            this();
            this.setMetricsLabelColor(labelColor);
            this.setMetricsMarkerColor(markerColor);
        }

        @Override
        public TimeModel cloneModel() {
            WeekDurationDurationModel clone = new WeekDurationDurationModel();
            clone.setMinimal(this.isMinimal());
            clone.setMetricsMarkerColor(this.getMetricsMarkerColor());
            clone.setMetricsLabelColor(this.getMetricsLabelColor());
            return clone;
        }

        @Override
        public List<Metrics> generateMetrics() {
            Calendar cal = Calendar.getInstance();
            Projection.Time time = this.getTimingManager().getTimingProjection();
            cal.setTime(time.getMinDate());
            Calendar ref = (Calendar)cal.clone();
            ref.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
            ref.set(7, 2);
            ArrayList<TimeDurationMetrics> weeksDuration = new ArrayList<TimeDurationMetrics>();
            List<TimePointMetrics> mondayPoints = this.getTimingManager().generateDaysPoint(ref, time.durationDays(), 7, this);
            for (TimePointMetrics point : mondayPoints) {
                Calendar mondayCal = Calendar.getInstance();
                mondayCal.setTime(point.getTime());
                Calendar sundayCal = (Calendar)mondayCal.clone();
                sundayCal.set(7, 1);
                TimeDurationMetrics duration = this.getTimingManager().generateMetricsDuration(mondayCal, sundayCal, this);
                if (duration == null) continue;
                weeksDuration.add(duration);
            }
            return this.formatWeekDuration(weeksDuration);
        }

        public List<Metrics> formatWeekDuration(List<TimeDurationMetrics> durations) {
            ArrayList<Metrics> metrics = new ArrayList<Metrics>();
            for (TimeDurationMetrics duration : durations) {
                duration.setMetricsLabel(monthShortFormat.format(duration.getTimeCenter()) + "(" + dayNumberFormat.format(duration.getTimeStart()) + " - " + dayNumberFormat.format(duration.getTimeEnd()) + ")");
                metrics.add(duration);
            }
            return metrics;
        }
    }

    public static class WeekModel
    extends TimeModel {
        public WeekModel() {
            super(DAY_MILLIS * 7L, 40, "week familly", "one week", "week - 7 days", 18);
        }

        public WeekModel(Color themeColor) {
            this(themeColor, themeColor);
        }

        public WeekModel(Color markerColor, Color labelColor) {
            this();
            this.setMetricsLabelColor(labelColor);
            this.setMetricsMarkerColor(markerColor);
        }

        @Override
        public TimeModel cloneModel() {
            WeekModel clone = new WeekModel();
            clone.setMinimal(this.isMinimal());
            clone.setMetricsMarkerColor(this.getMetricsMarkerColor());
            clone.setMetricsLabelColor(this.getMetricsLabelColor());
            return clone;
        }

        @Override
        public List<Metrics> generateMetrics() {
            Calendar cal = Calendar.getInstance();
            Projection.Time time = this.getTimingManager().getTimingProjection();
            cal.setTime(time.getMinDate());
            Calendar ref = (Calendar)cal.clone();
            ref.set(cal.get(1), cal.get(2), cal.get(5), 12, 0, 0);
            ref.set(7, 2);
            List<TimePointMetrics> daysPoints = this.getTimingManager().generateDaysPoint(ref, time.durationDays(), 7, this);
            return this.getTimingManager().formatMetricsPoint(daysPoints, weekFormat);
        }
    }

    public static class DayLongTextModel
    extends TimeModel {
        public DayLongTextModel() {
            super(DAY_MILLIS, 160, "day familly", "one day with  text day/month label", "day - 24 hours", 18);
        }

        public DayLongTextModel(Color themeColor) {
            this(themeColor, themeColor);
        }

        public DayLongTextModel(Color markerColor, Color labelColor) {
            this();
            this.setMetricsLabelColor(labelColor);
            this.setMetricsMarkerColor(markerColor);
        }

        @Override
        public TimeModel cloneModel() {
            DayLongTextModel clone = new DayLongTextModel();
            clone.setMinimal(this.isMinimal());
            clone.setMetricsMarkerColor(this.getMetricsMarkerColor());
            clone.setMetricsLabelColor(this.getMetricsLabelColor());
            return clone;
        }

        @Override
        public List<Metrics> generateMetrics() {
            Calendar cal = Calendar.getInstance();
            Projection.Time time = this.getTimingManager().getTimingProjection();
            cal.setTime(time.getMinDate());
            Calendar ref = (Calendar)cal.clone();
            ref.set(cal.get(1), cal.get(2), cal.get(5), 12, 0, 0);
            List<TimePointMetrics> daysPoints = this.getTimingManager().generateDaysPoint(ref, time.durationDays(), 1, this);
            return this.getTimingManager().formatMetricsPoint(daysPoints, dayLongLabelFormat);
        }
    }

    public static class DayShortTextModel
    extends TimeModel {
        public DayShortTextModel() {
            super(DAY_MILLIS, 80, "day familly", "one day with text label", "day - 24 hours", 18);
        }

        public DayShortTextModel(Color themeColor) {
            this(themeColor, themeColor);
        }

        public DayShortTextModel(Color markerColor, Color labelColor) {
            this();
            this.setMetricsLabelColor(labelColor);
            this.setMetricsMarkerColor(markerColor);
        }

        @Override
        public TimeModel cloneModel() {
            DayShortTextModel clone = new DayShortTextModel();
            clone.setMinimal(this.isMinimal());
            clone.setMetricsMarkerColor(this.getMetricsMarkerColor());
            clone.setMetricsLabelColor(this.getMetricsLabelColor());
            return clone;
        }

        @Override
        public List<Metrics> generateMetrics() {
            Calendar cal = Calendar.getInstance();
            Projection.Time time = this.getTimingManager().getTimingProjection();
            cal.setTime(time.getMinDate());
            Calendar ref = (Calendar)cal.clone();
            ref.set(cal.get(1), cal.get(2), cal.get(5), 12, 0, 0);
            List<TimePointMetrics> daysPoints = this.getTimingManager().generateDaysPoint(ref, time.durationDays(), 1, this);
            return this.getTimingManager().formatMetricsPoint(daysPoints, dayLabelFormat);
        }
    }

    public static class DayNumberModel
    extends TimeModel {
        public DayNumberModel() {
            super(DAY_MILLIS, 40, "day familly", "one day", "day - 24 hours", 18);
        }

        public DayNumberModel(Color themeColor) {
            this(themeColor, themeColor);
        }

        public DayNumberModel(Color markerColor, Color labelColor) {
            this();
            this.setMetricsLabelColor(labelColor);
            this.setMetricsMarkerColor(markerColor);
        }

        @Override
        public TimeModel cloneModel() {
            DayNumberModel clone = new DayNumberModel();
            clone.setMinimal(this.isMinimal());
            clone.setMetricsMarkerColor(this.getMetricsMarkerColor());
            clone.setMetricsLabelColor(this.getMetricsLabelColor());
            return clone;
        }

        @Override
        public List<Metrics> generateMetrics() {
            Calendar cal = Calendar.getInstance();
            Projection.Time time = this.getTimingManager().getTimingProjection();
            cal.setTime(time.getMinDate());
            Calendar ref = (Calendar)cal.clone();
            ref.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
            List<TimePointMetrics> daysPoints = this.getTimingManager().generateDaysPoint(ref, time.durationDays(), 1, this);
            return this.getTimingManager().formatMetricsPoint(daysPoints, dayNumberFormat);
        }
    }

    public static class Hour3Model
    extends TimeModel {
        public Hour3Model() {
            super(HOUR_MILLIS * 3L, 40, "hour familly", "three hours", "hour", 18);
        }

        public Hour3Model(Color themeColor) {
            this(themeColor, themeColor);
        }

        public Hour3Model(Color markerColor, Color labelColor) {
            this();
            this.setMetricsLabelColor(labelColor);
            this.setMetricsMarkerColor(markerColor);
        }

        @Override
        public TimeModel cloneModel() {
            Hour3Model clone = new Hour3Model();
            clone.setMinimal(this.isMinimal());
            clone.setMetricsMarkerColor(this.getMetricsMarkerColor());
            clone.setMetricsLabelColor(this.getMetricsLabelColor());
            return clone;
        }

        @Override
        public List<Metrics> generateMetrics() {
            Calendar cal = Calendar.getInstance();
            Projection.Time time = this.getTimingManager().getTimingProjection();
            cal.setTime(time.getMinDate());
            Calendar ref = (Calendar)cal.clone();
            ref.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
            List<TimePointMetrics> hoursPoints = this.getTimingManager().generateHoursPoint(ref, time.durationHours(), 3, this);
            return this.getTimingManager().formatMetricsPoint(hoursPoints, hourFormat);
        }
    }

    public static class HourModel
    extends TimeModel {
        public HourModel() {
            super(HOUR_MILLIS, 40, "hour familly", "one hour", "hour", 18);
        }

        public HourModel(Color themeColor) {
            this(themeColor, themeColor);
        }

        public HourModel(Color markerColor, Color labelColor) {
            this();
            this.setMetricsLabelColor(labelColor);
            this.setMetricsMarkerColor(markerColor);
        }

        @Override
        public TimeModel cloneModel() {
            HourModel clone = new HourModel();
            clone.setMinimal(this.isMinimal());
            clone.setMetricsMarkerColor(this.getMetricsMarkerColor());
            clone.setMetricsLabelColor(this.getMetricsLabelColor());
            return clone;
        }

        @Override
        public List<Metrics> generateMetrics() {
            Calendar cal = Calendar.getInstance();
            Projection.Time time = this.getTimingManager().getTimingProjection();
            cal.setTime(time.getMinDate());
            Calendar ref = (Calendar)cal.clone();
            ref.set(cal.get(1), cal.get(2), cal.get(5), cal.get(11), 0, 0);
            List<TimePointMetrics> hoursPoints = this.getTimingManager().generateHoursPoint(ref, time.durationHours(), 1, this);
            return this.getTimingManager().formatMetricsPoint(hoursPoints, hourFormat);
        }
    }

    public static class Minute20Model
    extends TimeModel {
        public Minute20Model() {
            super(MINUTE_MILLIS * 20L, 40, "minute familly", "twenty minutes", "minute", 18);
        }

        public Minute20Model(Color themeColor) {
            this(themeColor, themeColor);
        }

        public Minute20Model(Color markerColor, Color labelColor) {
            this();
            this.setMetricsLabelColor(labelColor);
            this.setMetricsMarkerColor(markerColor);
        }

        @Override
        public TimeModel cloneModel() {
            Minute20Model clone = new Minute20Model();
            clone.setMinimal(this.isMinimal());
            clone.setMetricsMarkerColor(this.getMetricsMarkerColor());
            clone.setMetricsLabelColor(this.getMetricsLabelColor());
            return clone;
        }

        @Override
        public List<Metrics> generateMetrics() {
            Calendar cal = Calendar.getInstance();
            Projection.Time time = this.getTimingManager().getTimingProjection();
            cal.setTime(time.getMinDate());
            Calendar ref = (Calendar)cal.clone();
            ref.set(cal.get(1), cal.get(2), cal.get(5), cal.get(11), 0, 0);
            List<TimePointMetrics> minutesPoints = this.getTimingManager().generateMinutesPoint(ref, time.durationMinutes(), 20, this);
            return this.getTimingManager().formatMetricsPoint(minutesPoints, minuteFormat);
        }
    }

    public static class Minute15Model
    extends TimeModel {
        public Minute15Model() {
            super(MINUTE_MILLIS * 15L, 40, "minute familly", "fifteen minutes", "minute", 18);
        }

        public Minute15Model(Color themeColor) {
            this(themeColor, themeColor);
        }

        public Minute15Model(Color markerColor, Color labelColor) {
            this();
            this.setMetricsLabelColor(labelColor);
            this.setMetricsMarkerColor(markerColor);
        }

        @Override
        public TimeModel cloneModel() {
            Minute15Model clone = new Minute15Model();
            clone.setMinimal(this.isMinimal());
            clone.setMetricsMarkerColor(this.getMetricsMarkerColor());
            clone.setMetricsLabelColor(this.getMetricsLabelColor());
            return clone;
        }

        @Override
        public List<Metrics> generateMetrics() {
            Calendar cal = Calendar.getInstance();
            Projection.Time time = this.getTimingManager().getTimingProjection();
            cal.setTime(time.getMinDate());
            Calendar ref = (Calendar)cal.clone();
            ref.set(cal.get(1), cal.get(2), cal.get(5), cal.get(11), 0, 0);
            List<TimePointMetrics> minutesPoints = this.getTimingManager().generateMinutesPoint(ref, time.durationMinutes(), 15, this);
            return this.getTimingManager().formatMetricsPoint(minutesPoints, minuteFormat);
        }
    }

    public static class Minute10Model
    extends TimeModel {
        public Minute10Model() {
            super(MINUTE_MILLIS * 10L, 40, "minute familly", "ten minutes", "minute", 18);
        }

        public Minute10Model(Color themeColor) {
            this(themeColor, themeColor);
        }

        public Minute10Model(Color markerColor, Color labelColor) {
            this();
            this.setMetricsLabelColor(labelColor);
            this.setMetricsMarkerColor(markerColor);
        }

        @Override
        public TimeModel cloneModel() {
            Minute10Model clone = new Minute10Model();
            clone.setMinimal(this.isMinimal());
            clone.setMetricsMarkerColor(this.getMetricsMarkerColor());
            clone.setMetricsLabelColor(this.getMetricsLabelColor());
            return clone;
        }

        @Override
        public List<Metrics> generateMetrics() {
            Calendar cal = Calendar.getInstance();
            Projection.Time time = this.getTimingManager().getTimingProjection();
            cal.setTime(time.getMinDate());
            Calendar ref = (Calendar)cal.clone();
            ref.set(cal.get(1), cal.get(2), cal.get(5), cal.get(11), 0, 0);
            List<TimePointMetrics> minutesPoints = this.getTimingManager().generateMinutesPoint(ref, time.durationMinutes(), 10, this);
            return this.getTimingManager().formatMetricsPoint(minutesPoints, minuteFormat);
        }
    }

    public static class Minute1Model
    extends TimeModel {
        public Minute1Model() {
            super(MINUTE_MILLIS, 40, "minute familly", "one minute", "minute", 18);
        }

        public Minute1Model(Color themeColor) {
            this(themeColor, themeColor);
        }

        public Minute1Model(Color markerColor, Color labelColor) {
            this();
            this.setMetricsLabelColor(labelColor);
            this.setMetricsMarkerColor(markerColor);
        }

        @Override
        public TimeModel cloneModel() {
            Minute1Model clone = new Minute1Model();
            clone.setMinimal(this.isMinimal());
            clone.setMetricsMarkerColor(this.getMetricsMarkerColor());
            clone.setMetricsLabelColor(this.getMetricsLabelColor());
            return clone;
        }

        @Override
        public List<Metrics> generateMetrics() {
            Calendar cal = Calendar.getInstance();
            Projection.Time time = this.getTimingManager().getTimingProjection();
            cal.setTime(time.getMinDate());
            Calendar ref = (Calendar)cal.clone();
            ref.set(cal.get(1), cal.get(2), cal.get(5), cal.get(11), cal.get(12), 0);
            List<TimePointMetrics> points = this.getTimingManager().generateMinutesPoint(ref, time.durationMinutes(), 1, this);
            return this.getTimingManager().formatMetricsPoint(points, minuteFormat);
        }
    }

    public static abstract class TimeModel {
        private TimeMetricsManager timingManager;
        private long millis;
        private int pixelLabelHolder = 6;
        private String familyName;
        private String name;
        private String unit;
        private int rank;
        private Color metricsLabelColor;
        private Color metricsMarkerColor;
        private int pixelAxisHolder = 20;
        private boolean minimal = false;

        public abstract List<Metrics> generateMetrics();

        public abstract TimeModel cloneModel();

        public TimeModel(long millis, int pixelLabelHolder, String famillyName, String name, String unit, int pixelAxisHolder) {
            this.millis = millis;
            this.pixelLabelHolder = pixelLabelHolder;
            this.familyName = famillyName;
            this.name = name;
            this.unit = unit;
            this.pixelAxisHolder = pixelAxisHolder;
        }

        public int getRank() {
            return this.rank;
        }

        public void setRank(int rank) {
            this.rank = rank;
        }

        public int getPixelAxisHolder() {
            return this.pixelAxisHolder;
        }

        public void setPixelAxisHolder(int pixelAxisHolder) {
            this.pixelAxisHolder = pixelAxisHolder;
        }

        public TimeMetricsManager getTimingManager() {
            return this.timingManager;
        }

        public void setTimingManager(TimeMetricsManager timingManager) {
            this.timingManager = timingManager;
        }

        public long getMillis() {
            return this.millis;
        }

        public int getPixelLabelHolder() {
            return this.pixelLabelHolder;
        }

        public void setPixelLabelHolder(int pixelLabelHolder) {
            this.pixelLabelHolder = pixelLabelHolder;
        }

        public String getFamilyName() {
            return this.familyName;
        }

        public String getName() {
            return this.name;
        }

        public String getUnit() {
            return this.unit;
        }

        public Color getMetricsLabelColor() {
            return this.metricsLabelColor;
        }

        public void setMetricsLabelColor(Color metricsLabelColor) {
            this.metricsLabelColor = metricsLabelColor;
        }

        public Color getMetricsMarkerColor() {
            return this.metricsMarkerColor;
        }

        public void setMetricsMarkerColor(Color metricsMarkerColor) {
            this.metricsMarkerColor = metricsMarkerColor;
        }

        public boolean isMinimal() {
            return this.minimal;
        }

        public void setMinimal(boolean minimal) {
            this.minimal = minimal;
            if (minimal) {
                this.setPixelLabelHolder(6);
                this.setPixelAxisHolder(0);
            } else {
                this.setPixelLabelHolder(20);
                this.setPixelAxisHolder(18);
            }
        }

        public String toString() {
            return "TimeModel [millis=" + this.millis + ", pixelHolder=" + this.pixelLabelHolder + ", familyName=" + this.familyName + ", name=" + this.name + ", unit=" + this.unit + "]";
        }
    }

    public class TimeModelComparator
    implements Comparator<TimeModel> {
        @Override
        public int compare(TimeModel tm1, TimeModel tm2) {
            if (tm1.getMillis() > tm2.getMillis()) {
                return 1;
            }
            if (tm1.getMillis() > tm2.getMillis()) {
                return -1;
            }
            if (!tm1.isMinimal() && tm2.isMinimal()) {
                return 1;
            }
            if (tm1.isMinimal() && !tm2.isMinimal()) {
                return -1;
            }
            return 0;
        }
    }
}

