/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.minidevice;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.minidevice.MiniDevicePlugin;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;
import org.jensoft.core.widget.Widget;

public class MiniDeviceWidget
extends Widget {
    public static final String ID = "@widget/minidevice";

    public MiniDeviceWidget() {
        super(ID);
    }

    @Override
    public final boolean isCompatiblePlugin() {
        return this.getHost() != null && this.getHost() instanceof MiniDevicePlugin;
    }

    @Override
    protected void paintWidget(View v2d, Graphics2D g2d) {
        int miniHeight;
        int miniWidth;
        MiniDevicePlugin host = (MiniDevicePlugin)this.getHost();
        if (host.getDimentionType() == MiniDevicePlugin.DimensionType.Ratio) {
            miniWidth = v2d.getDevice2D().getDeviceWidth() / host.getMiniDeviceRatioX();
            miniHeight = v2d.getDevice2D().getDeviceHeight() / host.getMiniDeviceRatioY();
        } else {
            miniWidth = host.getMiniDevicePixelX();
            miniHeight = host.getMiniDevicePixelY();
        }
        this.setWidth(miniWidth);
        this.setHeight(miniHeight);
        host.getPrivateProjection().setView(v2d);
        double minX = host.getPrivateProjection().getMinX();
        double maxX = host.getPrivateProjection().getMaxX();
        double minY = host.getPrivateProjection().getMinY();
        double maxY = host.getPrivateProjection().getMaxY();
        Point2D.Double p2d1 = new Point2D.Double(minX, maxY);
        Point2D.Double p2d2 = new Point2D.Double(minX, minY);
        Point2D.Double p2d3 = new Point2D.Double(maxX, minY);
        Point2D.Double p2d4 = new Point2D.Double(maxX, maxY);
        host.getPrivateProjection().setDevice2D(host);
        Point2D p2d1D = host.getPrivateProjection().userToPixel(p2d1);
        Point2D p2d2D = host.getPrivateProjection().userToPixel(p2d2);
        Point2D p2d3D = host.getPrivateProjection().userToPixel(p2d3);
        Point2D p2d4D = host.getPrivateProjection().userToPixel(p2d4);
        double uWidth = p2d4D.getX() - p2d1D.getX();
        double uHeight = p2d3D.getY() - p2d4D.getY();
        g2d.setStroke(new BasicStroke());
        Rectangle2D.Double rect2DMiniDevice = new Rectangle2D.Double(host.getOriginX(), host.getOriginY(), host.getDeviceWidth(), host.getDeviceHeight());
        Rectangle2D.Double rect2DZone = null;
        int offset = 10;
        boolean busy1 = false;
        if (uWidth > Toolkit.getDefaultToolkit().getScreenSize().getWidth() && uHeight < Toolkit.getDefaultToolkit().getScreenSize().getHeight()) {
            rect2DZone = new Rectangle2D.Double(-offset, p2d1D.getY(), v2d.getDevice2D().getDeviceWidth() + 2 * offset, uHeight);
            busy1 = true;
        } else if (uWidth < Toolkit.getDefaultToolkit().getScreenSize().getWidth() && uHeight > Toolkit.getDefaultToolkit().getScreenSize().getHeight()) {
            rect2DZone = new Rectangle2D.Double(p2d1D.getX(), -offset, uWidth, v2d.getDevice2D().getDeviceHeight() + 2 * offset);
            busy1 = true;
        } else if (uWidth > Toolkit.getDefaultToolkit().getScreenSize().getWidth() && uHeight > Toolkit.getDefaultToolkit().getScreenSize().getHeight()) {
            rect2DZone = new Rectangle2D.Double(-offset, -offset, v2d.getDevice2D().getDeviceWidth() + 2 * offset, v2d.getDevice2D().getDeviceHeight() + 2 * offset);
            busy1 = true;
        } else if (uWidth < Toolkit.getDefaultToolkit().getScreenSize().getWidth() && uHeight < Toolkit.getDefaultToolkit().getScreenSize().getHeight()) {
            rect2DZone = new Rectangle2D.Double(p2d1D.getX(), p2d1D.getY(), uWidth, uHeight);
            busy1 = false;
        }
        if (rect2DZone == null) {
            return;
        }
        boolean busy2 = false;
        if (rect2DMiniDevice.contains(((Rectangle2D)rect2DZone).getBounds2D())) {
            double t2W = ((RectangularShape)rect2DMiniDevice).getWidth() / ((RectangularShape)rect2DZone).getWidth();
            double t2H = ((RectangularShape)rect2DMiniDevice).getHeight() / ((RectangularShape)rect2DZone).getHeight();
            if (t2W > 20.0 || t2H > 20.0) {
                busy2 = true;
            }
        }
        if (!busy1 && !busy2) {
            g2d.setColor(this.getThemeColor().brighter());
            g2d.setComposite(AlphaComposite.getInstance(3, 0.1f));
            g2d.fill(rect2DZone);
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g2d.draw(rect2DZone);
            g2d.setColor(Color.GREEN);
        } else {
            g2d.setFont(new Font("Tahoma", 0, 10));
            g2d.setColor(Color.WHITE);
            g2d.drawString("BUSY", (int)((RectangularShape)rect2DMiniDevice).getX() + 5, (int)((RectangularShape)rect2DMiniDevice).getY() + 10);
        }
        List<AbstractPlugin> layouts = host.getProjection().getPluginRegistry();
        for (AbstractPlugin layout : layouts) {
            if (layout.equals(this)) continue;
            System.out.println("paint layout in mini device : " + layout.getName());
            host.getPrivateProjection().setDevice2D(host);
            layout.setProjection(host.getPrivateProjection());
            layout.paint(v2d, g2d, ViewPart.Device);
            layout.setProjection(v2d.getActiveProjection());
        }
    }
}

