/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.morphe;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jensoft.core.plugin.morphe.Primitive;
import org.jensoft.core.projection.Projection;

public class Rectangle
extends Primitive {
    private double centerX;
    private double centerY;
    private double width;
    private double height;

    public Rectangle(double centerX, double centerY, double width, double height) {
        this.centerX = centerX;
        this.centerY = centerY;
        this.width = width;
        this.height = height;
    }

    public Rectangle(double width, double height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void draw(Graphics2D g2d) {
        if (this.getNature() == Primitive.PrimitiveNature.DEVICE) {
            Rectangle2D.Double rect2DDevice = new Rectangle2D.Double(this.centerX - this.width / 2.0, this.centerY - this.height / 2.0, this.width, this.height);
            g2d.setColor(this.getHost().getThemeColor());
            g2d.draw(rect2DDevice);
        } else if (this.getNature() == Primitive.PrimitiveNature.USER) {
            Projection w2d = this.getHost().getProjection();
            Point2D centerUser = w2d.userToPixel(new Point2D.Double(this.centerX, this.centerY));
            double left = this.centerX - this.width / 2.0;
            Point2D pLeft = w2d.userToPixel(new Point2D.Double(left, 0.0));
            double right = this.centerX + this.width / 2.0;
            Point2D pRight = w2d.userToPixel(new Point2D.Double(right, 0.0));
            double userWidth = pRight.getX() - pLeft.getX();
            double top = this.centerY - this.height / 2.0;
            Point2D pTop = w2d.userToPixel(new Point2D.Double(0.0, top));
            double bottom = this.centerY + this.height / 2.0;
            Point2D pBottom = w2d.userToPixel(new Point2D.Double(0.0, bottom));
            double userHeight = pTop.getY() - pBottom.getY();
            Rectangle2D.Double rect2DUser = new Rectangle2D.Double(centerUser.getX() - userWidth / 2.0, centerUser.getY() - userHeight / 2.0, userWidth, userHeight);
            g2d.setColor(this.getHost().getThemeColor());
            g2d.draw(rect2DUser);
        }
    }
}

