/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.morphe;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.jensoft.core.plugin.morphe.Primitive;

public class RegularPolygon
extends Primitive {
    private double x;
    private double y;
    private double radius;
    private double faceCount;
    double startAngleDegree = 60.0;
    private Shape polygonMorphe;

    public double getStartAngleDegree() {
        return this.startAngleDegree;
    }

    public void setStartAngleDegree(double startAngleDegree) {
        this.startAngleDegree = startAngleDegree;
    }

    public RegularPolygon(double x, double y, double radius, double faceCount) {
        this.x = x;
        this.y = y;
        this.radius = radius;
        this.faceCount = faceCount;
    }

    public RegularPolygon(double radius, double faceCount) {
        this.radius = radius;
        this.faceCount = faceCount;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getExternalRadius() {
        return this.radius;
    }

    public void setExternalRadius(double externalRadius) {
        this.radius = externalRadius;
    }

    public double getBranchCount() {
        return this.faceCount;
    }

    public void setBranchCount(double branchCount) {
        this.faceCount = branchCount;
    }

    public void createMorphe() {
        GeneralPath starMorphePath = new GeneralPath();
        double angleStar = 360.0 / this.faceCount;
        if (this.getNature() == Primitive.PrimitiveNature.DEVICE) {
            int i = 0;
            while ((double)i < this.faceCount) {
                double pXExternal = this.x + this.radius * Math.cos(Math.toRadians(this.startAngleDegree + angleStar * (double)i));
                double pYExternal = this.y - this.radius * Math.sin(Math.toRadians(this.startAngleDegree + angleStar * (double)i));
                double pXExternal2 = this.x + this.radius * Math.cos(Math.toRadians(this.startAngleDegree + angleStar * (double)(i + 1)));
                double pYExternal2 = this.y - this.radius * Math.sin(Math.toRadians(this.startAngleDegree + angleStar * (double)(i + 1)));
                Line2D.Double l = new Line2D.Double(pXExternal, pYExternal, pXExternal2, pYExternal2);
                starMorphePath.append(l, true);
                ++i;
            }
        } else if (this.getNature() == Primitive.PrimitiveNature.USER) {
            int i = 0;
            while ((double)i < this.faceCount) {
                Point2D u = this.getHost().getProjection().userToPixel(new Point2D.Double(this.x, this.y));
                double pXExternal = u.getX() + this.radius * Math.cos(Math.toRadians(this.startAngleDegree + angleStar * (double)i));
                double pYExternal = u.getY() - this.radius * Math.sin(Math.toRadians(this.startAngleDegree + angleStar * (double)i));
                double pXExternal2 = u.getX() + this.radius * Math.cos(Math.toRadians(this.startAngleDegree + angleStar * (double)(i + 1)));
                double pYExternal2 = u.getY() - this.radius * Math.sin(Math.toRadians(this.startAngleDegree + angleStar * (double)(i + 1)));
                Line2D.Double l = new Line2D.Double(pXExternal, pYExternal, pXExternal2, pYExternal2);
                starMorphePath.append(l, true);
                ++i;
            }
        }
        starMorphePath.closePath();
        this.polygonMorphe = starMorphePath;
    }

    public Shape getStarMorphe() {
        this.createMorphe();
        return this.polygonMorphe;
    }

    @Override
    public void draw(Graphics2D g2d) {
        this.createMorphe();
        g2d.setColor(Color.RED);
        g2d.draw(this.polygonMorphe);
    }
}

