/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.morphe;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.jensoft.core.plugin.morphe.Primitive;

public class Star
extends Primitive {
    private double x;
    private double y;
    private double internalRadius;
    private double externalRadius;
    private double branchCount;
    double startAngleDegree = 60.0;
    private Shape starMorphe;

    public double getStartAngleDegree() {
        return this.startAngleDegree;
    }

    public void setStartAngleDegree(double startAngleDegree) {
        this.startAngleDegree = startAngleDegree;
    }

    public Star(double x, double y, double internalRadius, double externalRadius, double branchCount) {
        this.x = x;
        this.y = y;
        this.internalRadius = internalRadius;
        this.externalRadius = externalRadius;
        this.branchCount = branchCount;
    }

    public Star(double internalRadius, double externalRadius, double branchCount) {
        this.internalRadius = internalRadius;
        this.externalRadius = externalRadius;
        this.branchCount = branchCount;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getInternalRadius() {
        return this.internalRadius;
    }

    public void setInternalRadius(double internalRadius) {
        this.internalRadius = internalRadius;
    }

    public double getExternalRadius() {
        return this.externalRadius;
    }

    public void setExternalRadius(double externalRadius) {
        this.externalRadius = externalRadius;
    }

    public double getBranchCount() {
        return this.branchCount;
    }

    public void setBranchCount(double branchCount) {
        this.branchCount = branchCount;
    }

    public void createMorphe() {
        GeneralPath starMorphePath = new GeneralPath();
        double angleStar = 360.0 / this.branchCount;
        if (this.getNature() == Primitive.PrimitiveNature.DEVICE) {
            int i = 0;
            while ((double)i < this.branchCount) {
                double pXExternal = this.x + this.externalRadius * Math.cos(Math.toRadians(this.startAngleDegree + angleStar * (double)i));
                double pYExternal = this.y - this.externalRadius * Math.sin(Math.toRadians(this.startAngleDegree + angleStar * (double)i));
                double pXInternal = this.x + this.internalRadius * Math.cos(Math.toRadians(this.startAngleDegree + angleStar * (double)i + angleStar / 2.0));
                double pYInternal = this.y - this.internalRadius * Math.sin(Math.toRadians(this.startAngleDegree + angleStar * (double)i + angleStar / 2.0));
                Line2D.Double l = new Line2D.Double(pXExternal, pYExternal, pXInternal, pYInternal);
                starMorphePath.append(l, true);
                ++i;
            }
        } else if (this.getNature() == Primitive.PrimitiveNature.USER) {
            int i = 0;
            while ((double)i < this.branchCount) {
                Point2D u = this.getHost().getProjection().userToPixel(new Point2D.Double(this.x, this.y));
                double pXExternal = u.getX() + this.externalRadius * Math.cos(Math.toRadians(this.startAngleDegree + angleStar * (double)i));
                double pYExternal = u.getY() - this.externalRadius * Math.sin(Math.toRadians(this.startAngleDegree + angleStar * (double)i));
                double pXInternal = u.getX() + this.internalRadius * Math.cos(Math.toRadians(this.startAngleDegree + angleStar * (double)i + angleStar / 2.0));
                double pYInternal = u.getY() - this.internalRadius * Math.sin(Math.toRadians(this.startAngleDegree + angleStar * (double)i + angleStar / 2.0));
                Line2D.Double l = new Line2D.Double(pXExternal, pYExternal, pXInternal, pYInternal);
                starMorphePath.append(l, true);
                ++i;
            }
        }
        starMorphePath.closePath();
        this.starMorphe = starMorphePath;
    }

    public Shape getStarMorphe() {
        this.createMorphe();
        return this.starMorphe;
    }

    @Override
    public void draw(Graphics2D g2d) {
        this.createMorphe();
        g2d.setColor(Color.RED);
        g2d.draw(this.starMorphe);
    }
}

