/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.outline;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import org.jensoft.core.plugin.outline.AbstractOutlinePainter;
import org.jensoft.core.view.ViewPart;

public class LineOutlinePainter
extends AbstractOutlinePainter {
    private boolean north = false;
    private boolean west = false;
    private boolean south = false;
    private boolean east = false;
    private Color northColor = Color.DARK_GRAY;
    private Color westColor = Color.DARK_GRAY;
    private Color southColor = Color.DARK_GRAY;
    private Color eastColor = Color.DARK_GRAY;
    private BasicStroke outlineStroke = new BasicStroke(1.4f);

    public LineOutlinePainter(boolean north, boolean west, boolean south, boolean east) {
        this.north = north;
        this.west = west;
        this.south = south;
        this.east = east;
    }

    public LineOutlinePainter(boolean north, Color northColor, boolean west, Color westColor, boolean south, Color southColor, boolean east, Color eastColor) {
        this.north = north;
        this.northColor = northColor;
        this.west = west;
        this.westColor = westColor;
        this.south = south;
        this.southColor = southColor;
        this.east = east;
        this.eastColor = eastColor;
    }

    public LineOutlinePainter(Color outlineColor, boolean north, boolean west, boolean south, boolean east) {
        this(north, outlineColor, west, outlineColor, south, outlineColor, east, outlineColor);
    }

    public LineOutlinePainter(Color outlineColor) {
        this(true, outlineColor, true, outlineColor, true, outlineColor, true, outlineColor);
    }

    @Override
    public void setOutlineColor(Color color) {
        super.setOutlineColor(color);
        this.northColor = color;
        this.westColor = color;
        this.southColor = color;
        this.eastColor = color;
    }

    @Override
    public void doPaintOutline(Component c, Graphics2D g2d, int startX, int startY, int weigh, ViewPart viewPart) {
        Line2D.Double l2dHorizontal;
        Line2D.Double l2dVertical;
        g2d.setStroke(this.outlineStroke);
        if (viewPart == ViewPart.East && this.east) {
            l2dVertical = new Line2D.Double(startX, startY, startX, startY - weigh);
            g2d.setColor(this.eastColor);
            g2d.setStroke(this.outlineStroke);
            g2d.draw(l2dVertical);
        }
        if (viewPart == ViewPart.West && this.west) {
            l2dVertical = new Line2D.Double(startX, startY, startX, startY - weigh);
            g2d.setColor(this.westColor);
            g2d.setStroke(this.outlineStroke);
            g2d.draw(l2dVertical);
        }
        if (viewPart == ViewPart.North && this.north) {
            l2dHorizontal = new Line2D.Double(startX, startY, startX + weigh, startY);
            g2d.setColor(this.northColor);
            g2d.setStroke(this.outlineStroke);
            g2d.draw(l2dHorizontal);
        }
        if (viewPart == ViewPart.South && this.south) {
            l2dHorizontal = new Line2D.Double(startX, startY, startX + weigh, startY);
            g2d.setColor(this.southColor);
            g2d.setStroke(this.outlineStroke);
            g2d.draw(l2dHorizontal);
        }
    }
}

