/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.outline;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import org.jensoft.core.device.Device;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.outline.AbstractOutlinePainter;
import org.jensoft.core.plugin.outline.AbstractOutlinePlugin;
import org.jensoft.core.plugin.outline.LineOutlinePainter;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class OutlinePlugin
extends AbstractOutlinePlugin {
    private AbstractOutlinePainter painter;
    private Color themeColor;
    private boolean inflating = false;
    private Rectangle2D inflateOutline;

    public OutlinePlugin() {
        this.setName("OutlinePlugin");
        this.setPriority(-1000);
    }

    public OutlinePlugin(Color themeColor) {
        this();
        this.themeColor = themeColor;
    }

    @Override
    public Color getThemeColor() {
        return this.themeColor;
    }

    @Override
    public void setThemeColor(Color themeColor) {
        this.themeColor = themeColor;
    }

    public AbstractOutlinePainter getPainter() {
        return this.painter;
    }

    public void setPainter(AbstractOutlinePainter painter) {
        this.painter = painter;
    }

    public boolean isInflating() {
        return this.inflating;
    }

    public void setInflating(boolean inflating) {
        this.inflating = inflating;
    }

    public InflateOutline inflateOutline() {
        if (this.isInflating()) {
            return null;
        }
        InflateOutline i = new InflateOutline();
        i.start();
        return i;
    }

    public InflateOutline inflateOutline(int startDelay) {
        if (this.isInflating()) {
            return null;
        }
        InflateOutline i = new InflateOutline(startDelay);
        i.start();
        return i;
    }

    public DeflateOutline deflateOutline() {
        if (this.isInflating()) {
            return null;
        }
        DeflateOutline d = new DeflateOutline();
        d.start();
        return d;
    }

    public DeflateOutline deflateOutline(int startDelay) {
        if (this.isInflating()) {
            return null;
        }
        DeflateOutline d = new DeflateOutline(startDelay);
        d.start();
        return d;
    }

    private void paintInflating(View view, Graphics2D g2d, ViewPart viewPart) {
        if (viewPart != ViewPart.Device) {
            return;
        }
        if (this.inflateOutline != null) {
            if (this.themeColor != null) {
                g2d.setColor(this.themeColor);
            } else {
                g2d.setColor(this.getProjection().getThemeColor());
            }
            g2d.draw(this.inflateOutline);
        }
    }

    @Override
    public void doPaintOutline(View view, Graphics2D g2d, ViewPart viewPart) {
        if (this.getPaintBehavior() == AbstractPlugin.PaintBehavior.NoPaint) {
            return;
        }
        if (this.getPaintBehavior() == AbstractPlugin.PaintBehavior.PaintIfHostProjectionActive && !this.getProjection().isLockActive()) {
            return;
        }
        if (this.painter == null) {
            this.painter = this.themeColor != null ? new LineOutlinePainter(this.themeColor) : new LineOutlinePainter(this.getProjection().getThemeColor());
        } else if (this.themeColor != null) {
            this.painter.setOutlineColor(this.themeColor);
        } else {
            this.painter.setOutlineColor(this.getProjection().getThemeColor());
        }
        if (this.isInflating() && viewPart == ViewPart.Device) {
            this.paintInflating(view, g2d, viewPart);
        } else if (!this.isInflating()) {
            if (viewPart == ViewPart.South) {
                JComponent south = view.getViewPartComponent(ViewPart.South);
                this.painter.doPaintOutline(south, g2d, view.getPlaceHolderAxisWest() - 1, 0, south.getWidth() - view.getPlaceHolderAxisEast() - view.getPlaceHolderAxisWest() + 1, ViewPart.South);
            }
            if (viewPart == ViewPart.West) {
                JComponent west = view.getViewPartComponent(ViewPart.West);
                this.painter.doPaintOutline(west, g2d, west.getWidth() - 1, west.getHeight(), west.getHeight(), ViewPart.West);
            }
            if (viewPart == ViewPart.East) {
                JComponent east = view.getViewPartComponent(ViewPart.East);
                this.painter.doPaintOutline(east, g2d, 0, east.getHeight(), east.getHeight(), ViewPart.East);
            }
            if (viewPart == ViewPart.North) {
                JComponent north = view.getViewPartComponent(ViewPart.North);
                this.painter.doPaintOutline(north, g2d, view.getPlaceHolderAxisWest() - 1, north.getHeight() - 1, north.getWidth() - view.getPlaceHolderAxisEast() - view.getPlaceHolderAxisWest() + 1, ViewPart.North);
            }
        }
    }

    public class DeflateOutline
    extends Thread {
        private int startDelay = 20;

        public DeflateOutline() {
        }

        public DeflateOutline(int startDelay) {
            this.startDelay = startDelay;
        }

        @Override
        public void run() {
            OutlinePlugin.this.setInflating(true);
            try {
                Projection w2d = OutlinePlugin.this.getProjection();
                if (w2d == null) {
                    this.interrupt();
                }
                w2d.getView().repaintView();
                Thread.sleep(this.startDelay);
                Device d2d = w2d.getDevice2D();
                int step = 20;
                int width = d2d.getDeviceWidth();
                int height = d2d.getDeviceHeight();
                double deltaWidth = width / 2 / step;
                double deltaHeight = height / 2 / step;
                for (int i = step; i >= 0; --i) {
                    double deltaWidthStep = deltaWidth * (double)i;
                    double deltaHeightStep = deltaHeight * (double)i;
                    Rectangle oldInflate = null;
                    if (OutlinePlugin.this.inflateOutline != null) {
                        oldInflate = OutlinePlugin.this.inflateOutline.getBounds();
                    }
                    OutlinePlugin.this.inflateOutline = new Rectangle2D.Double((double)(width / 2) - deltaWidthStep, (double)(height / 2) - deltaHeightStep, 2.0 * deltaWidthStep, 2.0 * deltaHeightStep);
                    if (oldInflate != null) {
                        w2d.getView().repaintDevice(oldInflate);
                    } else {
                        w2d.getView().repaintDevice();
                    }
                    Thread.sleep(20L);
                }
                OutlinePlugin.this.setInflating(false);
                w2d.getView().repaintView();
                OutlinePlugin.this.inflateOutline = null;
            }
            catch (InterruptedException e) {
                OutlinePlugin.this.inflateOutline = null;
                OutlinePlugin.this.setInflating(false);
                Thread.currentThread().interrupt();
            }
        }
    }

    public class InflateOutline
    extends Thread {
        private int startDelay = 20;

        public InflateOutline() {
        }

        public InflateOutline(int startDelay) {
            this.startDelay = startDelay;
        }

        @Override
        public void run() {
            OutlinePlugin.this.setInflating(true);
            try {
                Projection w2d = OutlinePlugin.this.getProjection();
                w2d.getView().repaintView();
                Thread.sleep(this.startDelay);
                Device d2d = w2d.getDevice2D();
                int step = 20;
                int width = d2d.getDeviceWidth();
                int height = d2d.getDeviceHeight();
                double deltaWidth = width / 2 / step;
                double deltaHeight = height / 2 / step;
                for (int i = 0; i <= step; ++i) {
                    double deltaWidthStep = deltaWidth * (double)i;
                    double deltaHeightStep = deltaHeight * (double)i;
                    OutlinePlugin.this.inflateOutline = new Rectangle2D.Double((double)(width / 2) - deltaWidthStep, (double)(height / 2) - deltaHeightStep, 2.0 * deltaWidthStep, 2.0 * deltaHeightStep);
                    w2d.getView().repaintDevice(OutlinePlugin.this.inflateOutline.getBounds());
                    Thread.sleep(20L);
                }
                OutlinePlugin.this.setInflating(false);
                w2d.getView().repaintView();
                OutlinePlugin.this.inflateOutline = null;
            }
            catch (InterruptedException e) {
                OutlinePlugin.this.inflateOutline = null;
                OutlinePlugin.this.setInflating(false);
                Thread.currentThread().interrupt();
            }
        }
    }
}

