/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pathmetrics;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;
import org.jensoft.core.glyphmetrics.AbstractMetricsPath;
import org.jensoft.core.glyphmetrics.GlyphMetric;
import org.jensoft.core.glyphmetrics.painter.draw.GlyphDefaultDraw;
import org.jensoft.core.glyphmetrics.painter.fill.GlyphDefaultFill;
import org.jensoft.core.glyphmetrics.painter.fill.GlyphFill;
import org.jensoft.core.glyphmetrics.painter.marker.DefaultMarker;
import org.jensoft.core.glyphmetrics.painter.marker.TicTacMarker;
import org.jensoft.core.graphics.AlphaInterpolation;
import org.jensoft.core.graphics.Antialiasing;
import org.jensoft.core.graphics.Dithering;
import org.jensoft.core.graphics.Fractional;
import org.jensoft.core.graphics.Interpolation;
import org.jensoft.core.graphics.TextAntialiasing;
import org.jensoft.core.palette.color.TangoPalette;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class MetricsPathPlugin
extends AbstractPlugin {
    private AbstractMetricsPath metricsPath;
    private GlyphDefaultFill fillWhite = new GlyphDefaultFill(Color.WHITE);
    private GlyphFill gradientWhiteRed = new GlyphFill(Color.WHITE, Color.RED);
    private DefaultMarker markerWhite = new DefaultMarker(Color.WHITE);
    private TicTacMarker tictacMarker = new TicTacMarker(TangoPalette.SCARLETRED3);
    private GlyphDefaultDraw drawWhite = new GlyphDefaultDraw(Color.WHITE);

    public MetricsPathPlugin(AbstractMetricsPath metricPath) {
        this.metricsPath = metricPath;
        this.setAntialiasing(Antialiasing.On);
        this.setFractionalMetrics(Fractional.On);
        this.setInterpolation(Interpolation.Bicubic);
        this.setTextAntialising(TextAntialiasing.On);
        this.setAlphaInterpolation(AlphaInterpolation.Quality);
        this.setDithering(Dithering.On);
    }

    @Override
    protected void paintPlugin(View view, Graphics2D g2d, ViewPart viewPart) {
        if (viewPart != ViewPart.Device) {
            return;
        }
        this.metricsPath.setSolveGeometryRequest(true);
        this.metricsPath.setProjection(this.getProjection());
        this.metricsPath.setFontRenderContext(g2d.getFontRenderContext());
        if (this.metricsPath.getPathPainter() != null) {
            this.metricsPath.getPathPainter().paintPath(g2d, this.metricsPath);
        }
        List<GlyphMetric> metrics = this.metricsPath.getMetrics();
        for (GlyphMetric glyphMetric : metrics) {
            if (glyphMetric.getGlyphMetricMarkerPainter() != null) {
                glyphMetric.getGlyphMetricMarkerPainter().paintGlyphMetric(g2d, glyphMetric);
            }
            if (glyphMetric.getGlyphMetricFill() != null) {
                glyphMetric.getGlyphMetricFill().paintGlyphMetric(g2d, glyphMetric);
            }
            if (glyphMetric.getGlyphMetricDraw() == null) continue;
            glyphMetric.getGlyphMetricDraw().paintGlyphMetric(g2d, glyphMetric);
        }
    }
}

