/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.graphics.Antialiasing;
import org.jensoft.core.graphics.Dithering;
import org.jensoft.core.graphics.TextAntialiasing;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.pie.Pie;
import org.jensoft.core.plugin.pie.PieEvent;
import org.jensoft.core.plugin.pie.PieListener;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.painter.label.AbstractPieSliceLabel;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class PiePlugin
extends AbstractPlugin
implements AbstractPlugin.OnClickListener,
AbstractPlugin.OnEnterListener,
AbstractPlugin.OnExitListener,
AbstractPlugin.OnPressListener,
AbstractPlugin.OnReleaseListener,
AbstractPlugin.OnMoveListener,
AbstractPlugin.OnDragListener {
    private List<Pie> pies;

    public PiePlugin() {
        this.setName("PiePlugin");
        this.pies = new ArrayList<Pie>();
        this.setOnMoveListener(this);
        this.setOnClickListener(this);
        this.setOnReleaseListener(this);
        this.setOnPressListener(this);
        this.setOnDragListener(this);
        this.setAntialiasing(Antialiasing.On);
        this.setTextAntialising(TextAntialiasing.On);
        this.setDithering(Dithering.On);
        this.setPriority(100);
    }

    public void addPie(Pie pie) {
        pie.setHostPlugin(this);
        this.pies.add(pie);
    }

    public List<Pie> getPies() {
        return this.pies;
    }

    public void setPies(List<Pie> pies) {
        this.pies = pies;
    }

    @Override
    protected void paintPlugin(View view, Graphics2D g2d, ViewPart viewPart) {
        if (viewPart != ViewPart.Device) {
            return;
        }
        for (Pie pie : this.pies) {
            pie.build();
            this.paintPie(view, g2d, pie);
            this.paintSlices(view, g2d, pie);
        }
    }

    private void paintPie(View view, Graphics2D g2d, Pie pie) {
        if (pie.getPieFill() != null) {
            pie.getPieFill().paintPie(g2d, pie);
        }
        if (pie.getPieDraw() != null) {
            pie.getPieDraw().paintPie(g2d, pie);
        }
        if (pie.getPieEffect() != null) {
            pie.getPieEffect().paintPie(g2d, pie);
        }
    }

    private void paintSlices(View view, Graphics2D g2d, Pie pie) {
        List<PieSlice> slices = pie.getSlices();
        for (PieSlice slice : slices) {
            if (slice.getSliceFill() != null) {
                slice.getSliceFill().paintPieSlice(g2d, pie, slice);
            }
            if (slice.getSliceDraw() != null) {
                slice.getSliceDraw().paintPieSlice(g2d, pie, slice);
            }
            if (slice.getSliceEffect() != null) {
                slice.getSliceEffect().paintPieSlice(g2d, pie, slice);
            }
            for (AbstractPieSliceLabel label : slice.getSliceLabels()) {
                label.paintPieSlice(g2d, pie, slice);
            }
        }
    }

    @Override
    public void onRelease(MouseEvent me) {
        for (Pie pie : this.pies) {
            for (PieSlice slice : pie.getSlices()) {
                if (slice.getSlicePath() == null || !slice.getSlicePath().contains(me.getX(), me.getY()) || !slice.isLockEnter()) continue;
                this.firePieReleased(slice);
            }
        }
    }

    @Override
    public void onPress(MouseEvent me) {
        for (Pie pie : this.pies) {
            for (PieSlice slice : pie.getSlices()) {
                if (slice.getSlicePath() == null || !slice.getSlicePath().contains(me.getX(), me.getY()) || !slice.isLockEnter()) continue;
                this.firePiePressed(slice);
            }
        }
    }

    @Override
    public void onExit(MouseEvent me) {
    }

    @Override
    public void onEnter(MouseEvent me) {
    }

    @Override
    public void onClick(MouseEvent me) {
        for (Pie pie : this.pies) {
            for (PieSlice slice : pie.getSlices()) {
                if (slice.getSlicePath() == null || !slice.getSlicePath().contains(me.getX(), me.getY()) || !slice.isLockEnter()) continue;
                this.firePieClicked(slice);
            }
        }
    }

    @Override
    public void onMove(MouseEvent me) {
        for (Pie pie : this.pies) {
            for (PieSlice slice : pie.getSlices()) {
                this.pieEnterExitTracker(slice, me.getX(), me.getY());
            }
        }
    }

    @Override
    public void onDrag(MouseEvent me) {
        for (Pie pie : this.pies) {
            for (PieSlice slice : pie.getSlices()) {
                this.pieEnterExitTracker(slice, me.getX(), me.getY());
            }
        }
    }

    private void pieEnterExitTracker(PieSlice slice, int x, int y) {
        if (slice == null || slice.getSlicePath() == null) {
            return;
        }
        if (slice.getSlicePath().contains(x, y) && !slice.isLockEnter()) {
            slice.lockEnter();
            this.firePieEntered(slice);
        } else if (!slice.getSlicePath().contains(x, y) && slice.isLockEnter()) {
            slice.unlockEnter();
            this.firePieExited(slice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePieEntered(PieSlice slice) {
        Object[] listeners;
        Object[] objectArray = listeners = slice.getHost().getPieListenerList().getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != PieListener.class) continue;
                ((PieListener)listeners[i + 1]).pieSliceEntered(new PieEvent(slice));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePieExited(PieSlice slice) {
        Object[] listeners;
        Object[] objectArray = listeners = slice.getHost().getPieListenerList().getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != PieListener.class) continue;
                ((PieListener)listeners[i + 1]).pieSliceExited(new PieEvent(slice));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePieClicked(PieSlice slice) {
        Object[] listeners;
        Object[] objectArray = listeners = slice.getHost().getPieListenerList().getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != PieListener.class) continue;
                ((PieListener)listeners[i + 1]).pieSliceClicked(new PieEvent(slice));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePiePressed(PieSlice slice) {
        Object[] listeners;
        Object[] objectArray = listeners = slice.getHost().getPieListenerList().getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != PieListener.class) continue;
                ((PieListener)listeners[i + 1]).pieSlicePressed(new PieEvent(slice));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePieReleased(PieSlice slice) {
        Object[] listeners;
        Object[] objectArray = listeners = slice.getHost().getPieListenerList().getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != PieListener.class) continue;
                ((PieListener)listeners[i + 1]).pieSliceReleased(new PieEvent(slice));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }
}

