/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.pie.Pie;
import org.jensoft.core.plugin.pie.painter.draw.AbstractPieSliceDraw;
import org.jensoft.core.plugin.pie.painter.effect.AbstractPieSliceEffect;
import org.jensoft.core.plugin.pie.painter.fill.AbstractPieSliceFill;
import org.jensoft.core.plugin.pie.painter.label.AbstractPieSliceLabel;
import org.jensoft.core.view.View;

public class PieSlice {
    private Pie host;
    private String name;
    private double value = 1.0;
    private double percent;
    private int divergence;
    private double startAngleDegree;
    private double endAngleDegree;
    private Color themeColor;
    private GeneralPath slicePath;
    private Arc2D externalArc;
    private Line2D lineStart;
    private Line2D lineEnd;
    private AbstractPieSliceDraw sliceDraw;
    private AbstractPieSliceFill sliceFill;
    private AbstractPieSliceEffect sliceEffect;
    private List<AbstractPieSliceLabel> sliceLabels;
    private boolean lockEnter = false;
    private float alpha = 1.0f;

    public PieSlice(String name, Color themeColor) {
        this.name = name;
        this.themeColor = themeColor;
        this.divergence = 0;
        this.sliceLabels = new ArrayList<AbstractPieSliceLabel>();
    }

    public PieSlice(String name, Color themeColor, double value) {
        this.name = name;
        this.themeColor = themeColor;
        this.value = value;
        this.divergence = 0;
        this.sliceLabels = new ArrayList<AbstractPieSliceLabel>();
    }

    public Pie getHost() {
        return this.host;
    }

    public View getView() {
        return this.getHost().getHostPlugin().getProjection().getView();
    }

    public void setHost(Pie host) {
        this.host = host;
    }

    public Arc2D getExternalArc() {
        return this.externalArc;
    }

    public void setExternalArc(Arc2D externalArc) {
        this.externalArc = externalArc;
    }

    public Line2D getLineStart() {
        return this.lineStart;
    }

    public void setLineStart(Line2D lineStart) {
        this.lineStart = lineStart;
    }

    public Line2D getLineEnd() {
        return this.lineEnd;
    }

    public void setLineEnd(Line2D lineEnd) {
        this.lineEnd = lineEnd;
    }

    public GeneralPath getSlicePath() {
        return this.slicePath;
    }

    public Rectangle2D getBounds2D() {
        if (this.slicePath != null) {
            return this.slicePath.getBounds2D();
        }
        return null;
    }

    public Rectangle getBounds() {
        if (this.slicePath != null) {
            return this.slicePath.getBounds();
        }
        return null;
    }

    public void setSlicePath(GeneralPath path) {
        this.slicePath = path;
    }

    public double getStartAngleDegree() {
        return this.startAngleDegree;
    }

    public void setStartAngleDegree(double startAngleDegree) {
        this.startAngleDegree = startAngleDegree;
    }

    public double getEndAngleDegree() {
        return this.endAngleDegree;
    }

    public void setEndAngleDegree(double endAngleDegree) {
        this.endAngleDegree = endAngleDegree;
    }

    public double getMedianAngleDegree() {
        return this.getStartAngleDegree() + this.getExtendsDegree() / 2.0;
    }

    public double getExtendsDegree() {
        return Math.abs(this.getEndAngleDegree() - this.getStartAngleDegree());
    }

    public Color getThemeColor() {
        return this.themeColor;
    }

    public void setThemeColor(Color themeColor) {
        this.themeColor = themeColor;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AbstractPieSliceDraw getSliceDraw() {
        return this.sliceDraw;
    }

    public void setSliceDraw(AbstractPieSliceDraw sliceDraw) {
        this.sliceDraw = sliceDraw;
    }

    public AbstractPieSliceFill getSliceFill() {
        return this.sliceFill;
    }

    public void setSliceFill(AbstractPieSliceFill sliceFill) {
        this.sliceFill = sliceFill;
    }

    public AbstractPieSliceEffect getSliceEffect() {
        return this.sliceEffect;
    }

    public void setSliceEffect(AbstractPieSliceEffect sliceEffect) {
        this.sliceEffect = sliceEffect;
    }

    public List<AbstractPieSliceLabel> getSliceLabels() {
        return this.sliceLabels;
    }

    public void setSliceLabels(List<AbstractPieSliceLabel> sliceLabels) {
        this.sliceLabels = sliceLabels;
    }

    public void addSliceLabel(AbstractPieSliceLabel sliceLabel) {
        this.sliceLabels.add(sliceLabel);
    }

    public void removeSliceLabel(AbstractPieSliceLabel sliceLabel) {
        this.sliceLabels.remove(sliceLabel);
    }

    public boolean containsSliceLabel(AbstractPieSliceLabel sliceLabel) {
        return this.sliceLabels.contains(sliceLabel);
    }

    public void removeAllSliceLabels() {
        this.sliceLabels.clear();
    }

    public double getPercent() {
        return this.percent;
    }

    public void setPercent(double percent) {
        this.percent = percent;
    }

    public int getDivergence() {
        return this.divergence;
    }

    public void setDivergence(int divergence) {
        this.divergence = divergence;
    }

    public boolean isLockEnter() {
        return this.lockEnter;
    }

    public void lockEnter() {
        if (!this.isLockEnter()) {
            this.lockEnter = true;
        }
    }

    public void unlockEnter() {
        if (this.isLockEnter()) {
            this.lockEnter = false;
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("slice alpha out of range [0,1]");
        }
        this.alpha = alpha;
    }
}

