/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie;

import java.awt.Color;
import java.awt.Font;
import java.util.List;
import org.jensoft.core.drawable.text.TextPath;
import org.jensoft.core.plugin.pie.Pie;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.painter.effect.AbstractPieEffect;
import org.jensoft.core.plugin.pie.painter.effect.AbstractPieSliceEffect;
import org.jensoft.core.plugin.pie.painter.fill.AbstractPieFill;
import org.jensoft.core.plugin.pie.painter.fill.AbstractPieSliceFill;
import org.jensoft.core.plugin.pie.painter.fill.PieDefaultFill;
import org.jensoft.core.plugin.pie.painter.label.PieBorderLabel;
import org.jensoft.core.plugin.pie.painter.label.PieBoundLabel;
import org.jensoft.core.plugin.pie.painter.label.PiePathLabel;
import org.jensoft.core.plugin.pie.painter.label.PieRadialLabel;

public class PieToolkit {
    public static Pie createPie(String name, double radius) {
        Pie pie = new Pie(name, radius);
        pie.setPieNature(Pie.PieNature.User);
        pie.setStartAngleDegree(0.0);
        pie.setCenterX(0.0);
        pie.setCenterY(0.0);
        pie.setPieFill(new PieDefaultFill());
        return pie;
    }

    public static Pie createPie(String name, int radius, double startAngleDegree) {
        Pie pie = new Pie(name, radius);
        pie.setPieNature(Pie.PieNature.User);
        pie.setStartAngleDegree(startAngleDegree);
        pie.setCenterX(0.0);
        pie.setCenterY(0.0);
        pie.setPieFill(new PieDefaultFill());
        return pie;
    }

    public static Pie createPie(String name, int radius, double startAngleDegree, AbstractPieEffect pieEffect) {
        Pie pie = new Pie(name, radius);
        pie.setPieNature(Pie.PieNature.User);
        pie.setStartAngleDegree(startAngleDegree);
        pie.setCenterX(0.0);
        pie.setCenterY(0.0);
        pie.setPieFill(new PieDefaultFill());
        pie.setPieEffect(pieEffect);
        return pie;
    }

    public static Pie createPie(String name, int radius, double startAngleDegree, AbstractPieFill pieFill) {
        Pie pie = new Pie(name, radius);
        pie.setPieNature(Pie.PieNature.User);
        pie.setStartAngleDegree(startAngleDegree);
        pie.setCenterX(0.0);
        pie.setCenterY(0.0);
        pie.setPieFill(pieFill);
        return pie;
    }

    public static Pie createPie(String name, int radius, double startAngleDegree, AbstractPieFill pieFill, AbstractPieEffect pieEffect) {
        Pie pie = new Pie(name, radius);
        pie.setPieNature(Pie.PieNature.User);
        pie.setStartAngleDegree(startAngleDegree);
        pie.setCenterX(0.0);
        pie.setCenterY(0.0);
        pie.setPieFill(pieFill);
        pie.setPieEffect(pieEffect);
        return pie;
    }

    public static PieSlice createSlice(String name, Color color, double value) {
        PieSlice slice = new PieSlice(name, color);
        slice.setValue(value);
        return slice;
    }

    public static PieSlice createSlice(String name, Color color, double value, AbstractPieSliceFill sliceFill) {
        PieSlice pieslice = new PieSlice(name, color);
        pieslice.setValue(value);
        pieslice.setSliceFill(sliceFill);
        return pieslice;
    }

    public static PieSlice createSlice(String name, Color color, double value, AbstractPieSliceFill sliceFill, AbstractPieSliceEffect sliceEffect) {
        PieSlice pieslice = new PieSlice(name, color);
        pieslice.setValue(value);
        pieslice.setSliceFill(sliceFill);
        pieslice.setSliceEffect(sliceEffect);
        return pieslice;
    }

    public static PieSlice createSlice(String name, Color color, double value, int divergence) {
        PieSlice pieslice = new PieSlice(name, color);
        pieslice.setValue(value);
        pieslice.setDivergence(divergence);
        return pieslice;
    }

    public static PieSlice createSlice(String name, Color color, double value, int divergence, AbstractPieSliceFill sliceFill) {
        PieSlice pieslice = new PieSlice(name, color);
        pieslice.setValue(value);
        pieslice.setDivergence(divergence);
        pieslice.setSliceFill(sliceFill);
        return pieslice;
    }

    public static PieSlice createSlice(String name, Color color, double value, int divergence, AbstractPieSliceFill sliceFill, AbstractPieSliceEffect sliceEffect) {
        PieSlice pieslice = new PieSlice(name, color);
        pieslice.setValue(value);
        pieslice.setDivergence(divergence);
        pieslice.setSliceFill(sliceFill);
        pieslice.setSliceEffect(sliceEffect);
        return pieslice;
    }

    public static PieBorderLabel createBorderLabel(String label) {
        PieBorderLabel pieBorderLabel = new PieBorderLabel();
        pieBorderLabel.setLabel(label);
        return pieBorderLabel;
    }

    public static PieBorderLabel createBorderLabel(String label, Color labelColor) {
        PieBorderLabel pieBorderLabel = new PieBorderLabel();
        pieBorderLabel.setLabel(label);
        pieBorderLabel.setLabelColor(labelColor);
        return pieBorderLabel;
    }

    public static PieBorderLabel createBorderLabel(String label, Color labelColor, Font labelFont) {
        PieBorderLabel pieBorderLabel = new PieBorderLabel();
        pieBorderLabel.setLabel(label);
        pieBorderLabel.setLabelColor(labelColor);
        pieBorderLabel.setLabelFont(labelFont);
        return pieBorderLabel;
    }

    public static PieBorderLabel createBorderLabel(String label, Color labelColor, Font labelFont, int margin) {
        PieBorderLabel pieBorderLabel = new PieBorderLabel();
        pieBorderLabel.setLabel(label);
        pieBorderLabel.setLabelColor(labelColor);
        pieBorderLabel.setLabelFont(labelFont);
        pieBorderLabel.setMargin(margin);
        return pieBorderLabel;
    }

    public static PieBoundLabel createBoundLabel(String label, Color labelColor) {
        PieBoundLabel piesliceBoundLabel = new PieBoundLabel(label, labelColor);
        return piesliceBoundLabel;
    }

    public static PieBoundLabel createBoundLabel(String label, Color labelColor, Font labelFont) {
        PieBoundLabel piesliceBoundLabel = new PieBoundLabel(label, labelColor, labelFont);
        return piesliceBoundLabel;
    }

    public static PieRadialLabel createRadialLabel(String label, Color labelColor) {
        PieRadialLabel pieRadialLabel = new PieRadialLabel(label, labelColor);
        return pieRadialLabel;
    }

    public static PieRadialLabel createRadialLabel(String label, Color labelColor, int offsetRadius) {
        PieRadialLabel pieRadialLabel = new PieRadialLabel(label, labelColor);
        pieRadialLabel.setOffsetRadius(offsetRadius);
        return pieRadialLabel;
    }

    public static PieRadialLabel createRadialLabel(String label, Color labelColor, int offsetRadius, Color outlineColor, Color fillColor) {
        PieRadialLabel pieRadialLabel = new PieRadialLabel(label, labelColor);
        pieRadialLabel.setOffsetRadius(offsetRadius);
        pieRadialLabel.setOutlineColor(outlineColor);
        pieRadialLabel.setFillColor(fillColor);
        return pieRadialLabel;
    }

    public static PieRadialLabel createRadialLabel(String label, Color labelColor, Font labelFont) {
        PieRadialLabel pieRadialLabel = new PieRadialLabel(label, labelColor, labelFont);
        return pieRadialLabel;
    }

    public static PieRadialLabel createRadialLabel(String label, Color labelColor, Font labelFont, int offsetRadius) {
        PieRadialLabel pieRadialLabel = new PieRadialLabel(label, labelColor, labelFont);
        pieRadialLabel.setOffsetRadius(offsetRadius);
        return pieRadialLabel;
    }

    public static PieRadialLabel createRadialLabel(String label, Color labelColor, Font labelFont, int offsetRadius, Color outlineColor, Color fillColor) {
        PieRadialLabel pieRadialLabel = new PieRadialLabel(label, labelColor, labelFont);
        pieRadialLabel.setOffsetRadius(offsetRadius);
        pieRadialLabel.setOutlineColor(outlineColor);
        pieRadialLabel.setFillColor(fillColor);
        return pieRadialLabel;
    }

    public static PiePathLabel createPathLabel(String label, Color labelColor) {
        PiePathLabel piePathLabel = new PiePathLabel(label, labelColor);
        return piePathLabel;
    }

    public static PiePathLabel createPathLabel(String label, Color labelColor, int divergence) {
        PiePathLabel piePathLabel = new PiePathLabel(label, labelColor);
        piePathLabel.setDivergence(divergence);
        return piePathLabel;
    }

    public static PiePathLabel createPathLabel(String label, Color labelColor, Font labelFont) {
        PiePathLabel piePathLabel = new PiePathLabel(label, labelColor, labelFont);
        return piePathLabel;
    }

    public static PiePathLabel createPathLabel(String label, Color labelColor, Font labelFont, int divergence) {
        PiePathLabel piePathLabel = new PiePathLabel(label, labelColor, labelFont);
        piePathLabel.setDivergence(divergence);
        return piePathLabel;
    }

    public static PiePathLabel createPathLabel(String label, Color labelColor, Font labelFont, TextPath.TextPosition textPosition) {
        PiePathLabel piePathLabel = new PiePathLabel(label, labelColor, labelFont);
        piePathLabel.setTextPosition(textPosition);
        return piePathLabel;
    }

    public static PiePathLabel createPathLabel(String label, Color labelColor, Font labelFont, TextPath.TextPosition textPosition, TextPath.PathSide pathSide) {
        PiePathLabel piePathLabel = new PiePathLabel(label, labelColor, labelFont);
        piePathLabel.setTextPosition(textPosition);
        piePathLabel.setPathSide(pathSide);
        return piePathLabel;
    }

    public static PiePathLabel createPathLabel(String label, Color labelColor, Font labelFont, TextPath.TextPosition textPosition, int divergence) {
        PiePathLabel piePathLabel = new PiePathLabel(label, labelColor, labelFont);
        piePathLabel.setTextPosition(textPosition);
        piePathLabel.setDivergence(divergence);
        return piePathLabel;
    }

    public static void pushSlices(Pie pie, PieSlice ... slices) {
        for (int i = 0; i < slices.length; ++i) {
            pie.addSlice(slices[i]);
        }
    }

    public static void pushSlices(Pie pie, List<PieSlice> slices) {
        for (PieSlice pieslice : slices) {
            pie.addSlice(pieslice);
        }
    }
}

