/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie.animator;

import org.jensoft.core.plugin.pie.Pie;
import org.jensoft.core.plugin.pie.PieEvent;
import org.jensoft.core.plugin.pie.PieListener;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.view.View;

public abstract class AbstractPieAnimator
implements PieListener {
    private Pie pie;

    public Pie getPie() {
        return this.pie;
    }

    public void setPie(Pie pie) {
        this.pie = pie;
    }

    protected void onEntered(PieSlice slice) {
    }

    protected void onExited(PieSlice slice) {
    }

    protected void onClicked(PieSlice slice) {
    }

    protected void onPressed(PieSlice slice) {
    }

    protected void onReleased(PieSlice slice) {
    }

    protected abstract Runnable getAnimator(PieSlice var1);

    @Override
    public final void pieSliceClicked(PieEvent e) {
        PieSlice slice = e.getSlice();
        this.onClicked(slice);
    }

    @Override
    public final void pieSlicePressed(PieEvent e) {
        PieSlice slice = e.getSlice();
        this.onPressed(slice);
    }

    @Override
    public final void pieSliceReleased(PieEvent e) {
        PieSlice slice = e.getSlice();
        this.onReleased(slice);
    }

    @Override
    public final void pieSliceEntered(PieEvent e) {
        PieSlice slice = e.getSlice();
        this.onEntered(slice);
    }

    @Override
    public final void pieSliceExited(PieEvent e) {
        PieSlice slice = e.getSlice();
        this.onExited(slice);
    }

    public View getView(PieSlice slice) {
        return slice.getHost().getHostPlugin().getProjection().getView();
    }
}

