/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie.animator;

import java.util.HashMap;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.animator.AbstractPieAnimator;

public class PieAlphaAnimator
extends AbstractPieAnimator {
    private int sleep = 40;
    private float alphaMin = 0.0f;
    private float alphaMax = 1.0f;
    private HashMap<PieSlice, AlphaTransition> transitions = new HashMap();
    private Thread t;

    public PieAlphaAnimator() {
    }

    public PieAlphaAnimator(float alphaMin, float alphaMax) {
        this.alphaMin = alphaMin;
        this.alphaMax = alphaMax;
    }

    public PieAlphaAnimator(float alphaMin, float alphaMax, int sleep) {
        this.alphaMin = alphaMin;
        this.alphaMax = alphaMax;
        this.sleep = sleep;
    }

    public float getAlphaMin() {
        return this.alphaMin;
    }

    public void setAlphaMin(float alphaMin) {
        this.alphaMin = alphaMin;
    }

    public float getAlphaMax() {
        return this.alphaMax;
    }

    public void setAlphaMax(float alphaMax) {
        this.alphaMax = alphaMax;
    }

    @Override
    protected void onPressed(PieSlice slice) {
        if (this.t == null) {
            this.t = new Thread(this.getAnimator(slice));
            this.t.start();
        } else if (!this.t.isAlive()) {
            this.t = new Thread(this.getAnimator(slice));
            this.t.start();
        }
    }

    public int getSleep() {
        return this.sleep;
    }

    public void setSleep(int sleep) {
        this.sleep = sleep;
    }

    @Override
    public Runnable getAnimator(PieSlice slice) {
        AlphaTransition at = this.transitions.get(slice);
        if (at == null) {
            AlphaTransition transition = new AlphaTransition(slice);
            this.transitions.put(slice, transition);
        }
        return this.transitions.get(slice);
    }

    public class AlphaTransition
    implements Runnable {
        private PieSlice slice;
        private TransitionState transitionState;

        public AlphaTransition(PieSlice slice) {
            this.slice = slice;
            this.transitionState = TransitionState.Off;
        }

        @Override
        public void run() {
            float step = 10.0f;
            try {
                if (this.transitionState == TransitionState.Off) {
                    float pas = (PieAlphaAnimator.this.alphaMax - PieAlphaAnimator.this.alphaMin) / new Float(step).floatValue();
                    int i = 0;
                    while ((float)i <= step) {
                        float alpha = PieAlphaAnimator.this.alphaMax - (float)i * pas;
                        if (alpha < PieAlphaAnimator.this.alphaMin) {
                            alpha = PieAlphaAnimator.this.alphaMin;
                        }
                        this.slice.setAlpha(alpha);
                        PieAlphaAnimator.this.getView(this.slice).repaintDevice();
                        Thread.sleep(PieAlphaAnimator.this.sleep);
                        ++i;
                    }
                    this.slice.setAlpha(PieAlphaAnimator.this.alphaMin);
                    PieAlphaAnimator.this.getView(this.slice).repaintDevice();
                    this.transitionState = TransitionState.On;
                } else if (this.transitionState == TransitionState.On) {
                    float pas = (PieAlphaAnimator.this.alphaMax - PieAlphaAnimator.this.alphaMin) / new Float(step).floatValue();
                    int i = 0;
                    while ((float)i <= step) {
                        float alpha = PieAlphaAnimator.this.alphaMin + (float)i * pas;
                        if (alpha > PieAlphaAnimator.this.alphaMax) {
                            alpha = PieAlphaAnimator.this.alphaMax;
                        }
                        this.slice.setAlpha(alpha);
                        PieAlphaAnimator.this.getView(this.slice).repaintDevice();
                        Thread.sleep(PieAlphaAnimator.this.sleep);
                        ++i;
                    }
                    this.slice.setAlpha(PieAlphaAnimator.this.alphaMax);
                    PieAlphaAnimator.this.getView(this.slice).repaintDevice();
                    this.transitionState = TransitionState.Off;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static enum TransitionState {
        On,
        Off;

    }
}

