/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie.animator;

import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.animator.AbstractPieAnimator;

public class PieDivergenceAnimator
extends AbstractPieAnimator {
    private int inflate = 20;
    private int sleep = 5;

    public PieDivergenceAnimator() {
    }

    public PieDivergenceAnimator(int inflate) {
        this.inflate = inflate;
    }

    public PieDivergenceAnimator(int inflate, int sleep) {
        this.inflate = inflate;
        this.sleep = sleep;
    }

    @Override
    protected void onPressed(PieSlice slice) {
        Thread t = new Thread(this.getAnimator(slice));
        t.start();
    }

    public int getInflate() {
        return this.inflate;
    }

    public void setInflate(int inflate) {
        this.inflate = inflate;
    }

    public int getSleep() {
        return this.sleep;
    }

    public void setSleep(int sleep) {
        this.sleep = sleep;
    }

    @Override
    public Runnable getAnimator(PieSlice slice) {
        return new DivergenceR(slice);
    }

    public class DivergenceR
    implements Runnable {
        private PieSlice slice;

        public DivergenceR(PieSlice slice) {
            this.slice = slice;
        }

        @Override
        public void run() {
            try {
                if (this.slice.getDivergence() == PieDivergenceAnimator.this.inflate) {
                    for (int i = 0; i <= PieDivergenceAnimator.this.inflate; ++i) {
                        this.slice.setDivergence(this.slice.getDivergence() - 1);
                        Thread.sleep(PieDivergenceAnimator.this.sleep);
                        PieDivergenceAnimator.this.getView(this.slice).repaintDevice();
                    }
                    this.slice.setDivergence(0);
                    PieDivergenceAnimator.this.getView(this.slice).repaintDevice();
                } else {
                    for (int i = 0; i <= PieDivergenceAnimator.this.inflate; ++i) {
                        this.slice.setDivergence(i);
                        Thread.sleep(PieDivergenceAnimator.this.sleep);
                        PieDivergenceAnimator.this.getView(this.slice).repaintDevice();
                    }
                    this.slice.setDivergence(PieDivergenceAnimator.this.inflate);
                    PieDivergenceAnimator.this.getView(this.slice).repaintDevice();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

