/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie.animator;

import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.animator.AbstractPieAnimator;
import org.jensoft.core.plugin.pie.painter.label.AbstractPieSliceLabel;

public class PieLabelAnimator
extends AbstractPieAnimator {
    private PieSlice slice;
    private AbstractPieSliceLabel sliceLabel;
    private ShowLabelBehavior showLabelBehavior = ShowLabelBehavior.ShowOnSliceRollover;

    public PieLabelAnimator(PieSlice slice, AbstractPieSliceLabel sliceLabel) {
        this.slice = slice;
        this.sliceLabel = sliceLabel;
    }

    public AbstractPieSliceLabel getSliceLabel() {
        return this.sliceLabel;
    }

    public void setSliceLabel(AbstractPieSliceLabel sliceLabel) {
        this.sliceLabel = sliceLabel;
    }

    @Override
    protected void onPressed(PieSlice slice) {
        if (this.showLabelBehavior == ShowLabelBehavior.ShowOnSlicePressed && slice.equals(this.slice) && slice.equals(this.slice)) {
            Thread t = new Thread(this.getAnimator(slice));
            t.start();
        }
    }

    @Override
    protected void onEntered(PieSlice slice) {
        if (this.showLabelBehavior == ShowLabelBehavior.ShowOnSliceRollover && slice.equals(this.slice) && slice.equals(this.slice)) {
            Thread t = new Thread(this.getAnimator(slice));
            t.start();
        }
    }

    @Override
    protected void onExited(PieSlice slice) {
        if (this.showLabelBehavior == ShowLabelBehavior.ShowOnSliceRollover && slice.equals(this.slice) && slice.equals(this.slice)) {
            Thread t = new Thread(this.getAnimator(slice));
            t.start();
        }
    }

    @Override
    public Runnable getAnimator(PieSlice slice) {
        return new LabelRunner(slice);
    }

    public class LabelRunner
    implements Runnable {
        private PieSlice animateSlice;

        public LabelRunner(PieSlice slice) {
            this.animateSlice = slice;
        }

        @Override
        public void run() {
            if (!this.animateSlice.containsSliceLabel(PieLabelAnimator.this.sliceLabel)) {
                this.animateSlice.addSliceLabel(PieLabelAnimator.this.sliceLabel);
            } else {
                this.animateSlice.removeSliceLabel(PieLabelAnimator.this.sliceLabel);
            }
            PieLabelAnimator.this.getView(this.animateSlice).repaintDevice();
        }
    }

    public static enum ShowLabelBehavior {
        ShowOnSlicePressed,
        ShowOnSliceRollover;

    }
}

