/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie.painter.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.List;
import org.jensoft.core.plugin.pie.Pie;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.painter.draw.AbstractPieDraw;

public class PieDefaultDraw
extends AbstractPieDraw {
    private Color drawColor;
    private Stroke drawStroke;
    private Stroke defaultStroke = new BasicStroke();

    public PieDefaultDraw() {
    }

    public PieDefaultDraw(Color drawColor, Stroke stroke) {
        this.drawColor = drawColor;
        this.drawStroke = stroke;
    }

    public PieDefaultDraw(Color drawColor) {
        this.drawColor = drawColor;
    }

    public Color getDrawColor() {
        return this.drawColor;
    }

    public void setDrawColor(Color drawColor) {
        this.drawColor = drawColor;
    }

    public Stroke getDrawStroke() {
        return this.drawStroke;
    }

    public void setDrawStroke(Stroke drawStroke) {
        this.drawStroke = drawStroke;
    }

    @Override
    protected final void paintPieDraw(Graphics2D g2d, Pie pie) {
        if (this.drawColor != null) {
            g2d.setColor(this.drawColor);
        } else {
            g2d.setColor(Color.WHITE);
        }
        if (this.drawStroke != null) {
            g2d.setStroke(this.drawStroke);
        } else {
            g2d.setStroke(this.defaultStroke);
        }
        List<PieSlice> sections = pie.getSlices();
        for (int i = 0; i < sections.size(); ++i) {
            PieSlice s = sections.get(i);
            g2d.draw(s.getSlicePath());
        }
    }
}

