/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie.painter.effect;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.plugin.pie.Pie;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.painter.effect.AbstractPieEffect;
import org.jensoft.core.plugin.pie.painter.effect.PieCompoundEffect;
import org.jensoft.core.plugin.pie.painter.effect.PieSliceLinearEffect;

public class PieLinearEffect
extends AbstractPieEffect {
    private int offsetRadius = 10;
    private int incidenceAngleDegree = 90;
    private PieSliceLinearEffect pieSliceLinearEffect;
    private float[] shadeFractions;
    private Color[] shadeColors;
    private boolean reload = false;
    private boolean shifting = false;

    public PieLinearEffect() {
    }

    public PieLinearEffect(int incidenceAngleDegree) {
        this();
        this.incidenceAngleDegree = incidenceAngleDegree;
    }

    public PieLinearEffect(int incidenceAngleDegree, int offsetRadius) {
        this(incidenceAngleDegree);
        if (offsetRadius < 0) {
            throw new IllegalArgumentException("offset radius should be greater than 0");
        }
        this.offsetRadius = offsetRadius;
    }

    public PieLinearEffect(int incidenceAngleDegree, int offsetRadius, float[] shadeFractions, Color[] shadeColors) {
        this(incidenceAngleDegree, offsetRadius);
        this.shadeFractions = shadeFractions;
        this.shadeColors = shadeColors;
    }

    public boolean isReload() {
        return this.reload;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    public int getOffsetRadius() {
        return this.offsetRadius;
    }

    public void setOffsetRadius(int offsetRadius) {
        if (offsetRadius < 0) {
            throw new IllegalArgumentException("offset radius should be greater than 0");
        }
        this.offsetRadius = offsetRadius;
        this.setReload(true);
    }

    public void setShader(float[] fractions, Color[] colors) {
        if (fractions.length != colors.length) {
            throw new IllegalArgumentException("length array does not match");
        }
        this.shadeFractions = fractions;
        this.shadeColors = colors;
    }

    public void setShader(Shader shader) {
        this.shadeFractions = shader.getFractions();
        this.shadeColors = shader.getColors();
    }

    public int getIncidenceAngleDegree() {
        return this.incidenceAngleDegree;
    }

    public void setIncidenceAngleDegree(int incidenceAngleDegree) {
        this.incidenceAngleDegree = incidenceAngleDegree;
        this.setReload(true);
    }

    public static Effect1ShiftIncidence shiftIncidence(Pie pie) {
        AbstractPieEffect effect = pie.getPieEffect();
        if (effect != null && (effect instanceof PieLinearEffect || effect instanceof PieCompoundEffect)) {
            Effect1ShiftIncidence shift = new Effect1ShiftIncidence(pie);
            shift.start();
            return shift;
        }
        return null;
    }

    public boolean isShifting() {
        return this.shifting;
    }

    public void setShifting(boolean shifting) {
        this.shifting = shifting;
    }

    @Override
    public final void paintPieEffect(Graphics2D g2d, Pie pie) {
        if (this.pieSliceLinearEffect == null || this.reload) {
            this.pieSliceLinearEffect = new PieSliceLinearEffect(this.incidenceAngleDegree, this.offsetRadius);
            if (this.shadeFractions != null && this.shadeColors != null) {
                this.pieSliceLinearEffect.setShader(this.shadeFractions, this.shadeColors);
            }
        }
        for (PieSlice slice : pie.getSlices()) {
            g2d.setComposite(AlphaComposite.getInstance(3, slice.getAlpha()));
            this.pieSliceLinearEffect.paintPieSlice(g2d, pie, slice);
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
    }

    public static class Effect1ShiftIncidence
    extends Thread {
        private Pie pie;
        private PieLinearEffect effect1;

        public Effect1ShiftIncidence(Pie pie) {
            this.pie = pie;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.pie.getPieEffect() instanceof PieLinearEffect) {
                    this.effect1 = (PieLinearEffect)this.pie.getPieEffect();
                    if (this.effect1.isShifting()) {
                        throw new InterruptedException("effect is already shifting.");
                    }
                    this.pie.getHostPlugin().getProjection().getView().repaintDevice();
                    this.effect1.setShifting(true);
                    block5: while (true) {
                        int i = 0;
                        while (true) {
                            if (i >= 90) continue block5;
                            this.effect1.setIncidenceAngleDegree(i * 4);
                            Thread.sleep(20L);
                            this.pie.getHostPlugin().getProjection().getView().repaintDevice();
                            ++i;
                        }
                        break;
                    }
                }
                if (this.pie.getPieEffect() instanceof PieCompoundEffect) {
                    PieCompoundEffect pc = (PieCompoundEffect)this.pie.getPieEffect();
                    AbstractPieEffect[] effects = pc.getEffects();
                    for (int i = 0; i < effects.length; ++i) {
                        if (!(effects[i] instanceof PieLinearEffect)) continue;
                        this.effect1 = (PieLinearEffect)effects[i];
                        if (this.effect1.isShifting()) {
                            throw new InterruptedException("effect is already shifting.");
                        }
                        this.pie.getHostPlugin().getProjection().getView().repaintDevice();
                        block8: while (true) {
                            int j = 0;
                            while (true) {
                                if (j >= 90) continue block8;
                                this.effect1.setIncidenceAngleDegree(j * 4);
                                Thread.sleep(20L);
                                this.pie.getHostPlugin().getProjection().getView().repaintDevice();
                                ++j;
                            }
                            break;
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                this.effect1.setShifting(false);
                Thread.currentThread().interrupt();
            }
            finally {
                this.effect1.setShifting(false);
            }
        }
    }
}

