/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie.painter.effect;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import org.jensoft.core.plugin.pie.Pie;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.painter.effect.AbstractPieEffect;
import org.jensoft.core.plugin.pie.painter.effect.Effect2ShiftIncidence;
import org.jensoft.core.plugin.pie.painter.effect.Effect2ShiftRadius;
import org.jensoft.core.plugin.pie.painter.effect.PieSliceRadialEffect;

public class PieRadialEffect
extends AbstractPieEffect {
    private Color[] shadeColors;
    private float[] shadeFractions;
    private int offsetRadius = 0;
    private int focusRadius = 0;
    private int focusAngle = 270;
    private PieSliceRadialEffect pieSliceRadialEffect;
    private boolean reload = false;
    private boolean shiftingFocusIncidence = false;
    private boolean shiftingFocusRadius = false;

    public PieRadialEffect() {
    }

    public PieRadialEffect(Color[] shadeColors, float[] shadeFractions) {
        this.shadeColors = shadeColors;
        this.shadeFractions = shadeFractions;
    }

    public boolean isReload() {
        return this.reload;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    public int getFocusRadius() {
        return this.focusRadius;
    }

    public void setFocusRadius(int focusRadius) {
        this.focusRadius = focusRadius;
        this.setReload(true);
    }

    public int getFocusAngle() {
        return this.focusAngle;
    }

    public void setFocusAngle(int focusAngle) {
        this.focusAngle = focusAngle;
        this.setReload(true);
    }

    public int getOffsetRadius() {
        return this.offsetRadius;
    }

    public void setOffsetRadius(int offsetRadius) {
        if (offsetRadius < 0) {
            throw new IllegalArgumentException("offset radius should be greater than 0");
        }
        this.offsetRadius = offsetRadius;
        this.setReload(true);
    }

    public void setShader(float[] fractions, Color[] colors) {
        if (fractions == null || colors == null) {
            return;
        }
        if (fractions.length != colors.length) {
            throw new IllegalArgumentException("length array does not match");
        }
        this.shadeFractions = fractions;
        this.shadeColors = colors;
        this.setReload(true);
    }

    public boolean isShiftingFocusIncidence() {
        return this.shiftingFocusIncidence;
    }

    public void setShiftingFocusIncidence(boolean shiftingFocusIncidence) {
        this.shiftingFocusIncidence = shiftingFocusIncidence;
    }

    public boolean isShiftingFocusRadius() {
        return this.shiftingFocusRadius;
    }

    public void setShiftingFocusRadius(boolean shiftingFocusRadius) {
        this.shiftingFocusRadius = shiftingFocusRadius;
    }

    public static void shiftIncidence(Pie pie) {
        AbstractPieEffect effect = pie.getPieEffect();
        if (effect != null && effect instanceof PieRadialEffect) {
            Effect2ShiftIncidence shift = new Effect2ShiftIncidence(pie);
            shift.start();
        }
    }

    public static void shiftRadius(Pie pie) {
        AbstractPieEffect effect = pie.getPieEffect();
        if (effect != null && effect instanceof PieRadialEffect) {
            Effect2ShiftRadius shift = new Effect2ShiftRadius(pie);
            shift.start();
        }
    }

    @Override
    public final void paintPieEffect(Graphics2D g2d, Pie pie) {
        if (this.pieSliceRadialEffect == null || this.reload) {
            this.pieSliceRadialEffect = new PieSliceRadialEffect(this.offsetRadius);
            this.pieSliceRadialEffect.setFocusAngle(this.focusAngle);
            this.pieSliceRadialEffect.setFocusRadius(this.focusRadius);
            if (this.shadeFractions != null && this.shadeColors != null && this.shadeFractions.length == this.shadeColors.length) {
                this.pieSliceRadialEffect.setShader(this.shadeFractions, this.shadeColors);
            }
        }
        for (PieSlice slice : pie.getSlices()) {
            g2d.setComposite(AlphaComposite.getInstance(3, slice.getAlpha()));
            this.pieSliceRadialEffect.paintPieSlice(g2d, pie, slice);
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
    }
}

