/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie.painter.effect;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.util.List;
import org.jensoft.core.graphics.ReflectionRenderer;
import org.jensoft.core.plugin.pie.Pie;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.painter.effect.AbstractPieEffect;
import org.jensoft.core.plugin.pie.painter.effect.PieCompoundEffect;
import org.jensoft.core.plugin.pie.painter.label.AbstractPieSliceLabel;

public class PieReflectionEffect
extends AbstractPieEffect {
    private float opacity = 0.5f;
    private float length = 0.3f;
    private boolean blurEnabled = true;
    private BufferedImage pieImage;
    private ReflectionRenderer renderer = new ReflectionRenderer();
    private BufferedImage reflection;
    private boolean reflectLabel = true;

    public PieReflectionEffect() {
        this.renderer.setOpacity(this.opacity);
        this.renderer.setLength(this.length);
        this.renderer.setBlurEnabled(this.blurEnabled);
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float opacity) {
        if (opacity < 0.0f) {
            opacity = 0.0f;
        } else if (opacity > 1.0f) {
            opacity = 1.0f;
        }
        this.opacity = opacity;
        this.renderer.setOpacity(opacity);
    }

    public float getLength() {
        return this.length;
    }

    public void setLength(float length) {
        if (length < 0.0f) {
            length = 0.0f;
        } else if (length > 1.0f) {
            length = 1.0f;
        }
        this.length = length;
        this.renderer.setLength(length);
    }

    public boolean isBlurEnabled() {
        return this.blurEnabled;
    }

    public void setBlurEnabled(boolean blurEnabled) {
        this.blurEnabled = blurEnabled;
        this.renderer.setBlurEnabled(blurEnabled);
    }

    public boolean isReflectLabel() {
        return this.reflectLabel;
    }

    public void setReflectLabel(boolean reflectLabel) {
        this.reflectLabel = reflectLabel;
    }

    @Override
    protected final void paintPieEffect(Graphics2D g2d, Pie pie) {
        try {
            this.pieImage = this.getPieImage(pie);
            this.reflection = this.renderer.createReflection(this.pieImage);
            Area a = pie.getPieArea();
            Rectangle rect = a.getBounds();
            g2d.drawImage((Image)this.reflection, (int)rect.getX(), (int)(rect.getY() + rect.getHeight()), null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public BufferedImage getPieImage(Pie pie) {
        Area pieArea = pie.getPieArea();
        Rectangle bound = pieArea.getBounds();
        int width = (int)bound.getWidth();
        int height = (int)bound.getHeight();
        BufferedImage pieImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = (Graphics2D)pieImage.getGraphics();
        pie.getHostPlugin().configureGraphics(g2d);
        g2d.translate(-((int)bound.getX()), -((int)bound.getY()));
        if (pie.getPieFill() != null) {
            pie.getPieFill().paintPie(g2d, pie);
        }
        if (pie.getPieDraw() != null) {
            pie.getPieDraw().paintPie(g2d, pie);
        }
        if (pie.getPieEffect() != null) {
            if (!pie.getPieEffect().equals(this) && !(pie.getPieEffect() instanceof PieCompoundEffect)) {
                pie.getPieEffect().paintPie(g2d, pie);
            }
            if (pie.getPieEffect() instanceof PieCompoundEffect) {
                PieCompoundEffect compound = (PieCompoundEffect)pie.getPieEffect();
                AbstractPieEffect[] effects = compound.getEffects();
                for (int i = 0; i < effects.length; ++i) {
                    if (effects[i].equals(this)) continue;
                    effects[i].paintPie(g2d, pie);
                }
            }
        }
        List<PieSlice> slices = pie.getSlices();
        for (PieSlice slice : slices) {
            if (slice.getSliceFill() != null) {
                slice.getSliceFill().paintPieSlice(g2d, pie, slice);
            }
            if (slice.getSliceDraw() != null) {
                slice.getSliceDraw().paintPieSlice(g2d, pie, slice);
            }
            if (slice.getSliceEffect() != null && !slice.getSliceEffect().equals(this)) {
                slice.getSliceEffect().paintPieSlice(g2d, pie, slice);
            }
            if (!this.isReflectLabel()) continue;
            for (AbstractPieSliceLabel label : slice.getSliceLabels()) {
                label.paintPieSlice(g2d, pie, slice);
            }
        }
        return pieImage;
    }
}

