/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie.painter.effect;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.plugin.pie.Pie;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.painter.effect.AbstractPieSliceEffect;

public class PieSliceLinearEffect
extends AbstractPieSliceEffect {
    private int offsetRadius = 5;
    private int incidenceAngleDegree = 90;
    private float[] shadeFractions;
    private Color[] shadeColors;
    private Color cStart = new Color(60, 60, 60, 180);
    private Color cEnd = new Color(255, 255, 255, 180);
    private float[] fractions = new float[]{0.0f, 0.49f, 0.51f, 1.0f};
    private Color[] colors = new Color[]{this.cStart, new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), this.cEnd};

    public PieSliceLinearEffect() {
    }

    public PieSliceLinearEffect(int incidenceAngleDegree) {
        this();
        this.incidenceAngleDegree = incidenceAngleDegree;
    }

    public PieSliceLinearEffect(int incidenceAngleDegree, int offsetRadius) {
        this(incidenceAngleDegree);
        if (offsetRadius < 0) {
            throw new IllegalArgumentException("offset radius should be greater than 0");
        }
        this.offsetRadius = offsetRadius;
    }

    public PieSliceLinearEffect(int incidenceAngleDegree, int offsetRadius, float[] shadeFractions, Color[] shadeColors) {
        this(incidenceAngleDegree, offsetRadius);
        this.shadeFractions = shadeFractions;
        this.shadeColors = shadeColors;
    }

    public int getOffsetRadius() {
        return this.offsetRadius;
    }

    public void setOffsetRadius(int offsetRadius) {
        if (offsetRadius < 0) {
            throw new IllegalArgumentException("offset radius should be greater than 0");
        }
        this.offsetRadius = offsetRadius;
    }

    public int getIncidenceAngleDegree() {
        return this.incidenceAngleDegree;
    }

    public void setIncidenceAngleDegree(int incidenceAngleDegree) {
        this.incidenceAngleDegree = incidenceAngleDegree;
    }

    public void setShader(float[] fractions, Color[] colors) {
        if (fractions.length != colors.length) {
            throw new IllegalArgumentException("length array does not match");
        }
        this.shadeFractions = fractions;
        this.shadeColors = colors;
    }

    public void setShader(Shader shader) {
        if (shader != null) {
            this.shadeFractions = shader.getFractions();
            this.shadeColors = shader.getColors();
        }
    }

    @Override
    protected void paintPieSliceEffect(Graphics2D g2d, Pie pie, PieSlice pieSection) {
        double endY;
        double endX;
        Point2D.Double end;
        double startY;
        double deltaDegree = pieSection.getPercent() * 360.0;
        double centerX = pie.getCenterX();
        double centerY = pie.getCenterY();
        double medianDegree = pieSection.getStartAngleDegree() + deltaDegree / 2.0;
        if (medianDegree > 360.0) {
            medianDegree -= 360.0;
        }
        Point2D c = null;
        if (pie.getPieNature() == Pie.PieNature.User) {
            c = pie.getHostPlugin().getProjection().userToPixel(new Point2D.Double(centerX, centerY));
        }
        if (pie.getPieNature() == Pie.PieNature.Device) {
            c = new Point2D.Double(centerX, centerY);
        }
        centerX = c.getX() + (double)pieSection.getDivergence() * Math.cos(Math.toRadians(medianDegree));
        centerY = c.getY() - (double)pieSection.getDivergence() * Math.sin(Math.toRadians(medianDegree));
        double radius = pie.getRadius();
        double innerRadius = radius - (double)this.offsetRadius;
        Ellipse2D.Double e2 = new Ellipse2D.Double(centerX - innerRadius, centerY - innerRadius, 2.0 * innerRadius, 2.0 * innerRadius);
        double startX = centerX + radius * Math.cos(Math.toRadians(this.incidenceAngleDegree));
        Point2D.Double start = new Point2D.Double(startX, startY = centerY - radius * Math.sin(Math.toRadians(this.incidenceAngleDegree)));
        if (start.equals(end = new Point2D.Double(endX = centerX + radius * Math.cos(Math.toRadians(this.incidenceAngleDegree + 180)), endY = centerY - radius * Math.sin(Math.toRadians(this.incidenceAngleDegree + 180))))) {
            return;
        }
        if (this.shadeFractions != null && this.shadeColors != null) {
            this.colors = this.shadeColors;
            this.fractions = this.shadeFractions;
        }
        LinearGradientPaint shader = new LinearGradientPaint(start, end, this.fractions, this.colors);
        g2d.setPaint(shader);
        Area a1 = new Area(e2);
        Area a2 = new Area(pieSection.getSlicePath());
        a2.intersect(a1);
        g2d.fill(a2);
    }
}

