/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie.painter.fill;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.geom.Point2D;
import org.jensoft.core.plugin.pie.Pie;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.painter.fill.AbstractPieSliceFill;

public class PieSliceRadialFill
extends AbstractPieSliceFill {
    private Color startColor;
    private Color endColor;

    public PieSliceRadialFill() {
    }

    public PieSliceRadialFill(Color startColor, Color endColor) {
        this.startColor = startColor;
        this.endColor = endColor;
    }

    @Override
    protected void paintPieSliceFill(Graphics2D g2d, Pie pie, PieSlice slice) {
        g2d.setColor(slice.getThemeColor());
        double centerX = pie.getCenterX();
        double centerY = pie.getCenterY();
        double deltaDegree = slice.getPercent() * 360.0;
        double medianDegree = slice.getStartAngleDegree() + deltaDegree / 2.0;
        if (medianDegree > 360.0) {
            medianDegree -= 360.0;
        }
        Point2D c = null;
        if (pie.getPieNature() == Pie.PieNature.User) {
            c = pie.getHostPlugin().getProjection().userToPixel(new Point2D.Double(centerX, centerY));
        }
        if (pie.getPieNature() == Pie.PieNature.Device) {
            c = new Point2D.Double(centerX, centerY);
        }
        centerX = c.getX() + (double)slice.getDivergence() * Math.cos(Math.toRadians(medianDegree));
        centerY = c.getY() - (double)slice.getDivergence() * Math.sin(Math.toRadians(medianDegree));
        Point2D.Double focus = new Point2D.Double(centerX + 30.0, centerY + 30.0);
        Point2D.Double cent = new Point2D.Double(centerX, centerY);
        double radius = pie.getRadius();
        float[] dist = new float[]{0.0f, 1.0f};
        Color cStart = slice.getThemeColor().brighter().brighter();
        Color cEnd = slice.getThemeColor();
        if (this.startColor != null) {
            cStart = this.startColor;
        }
        if (this.endColor != null) {
            cEnd = this.endColor;
        }
        Color[] cols = new Color[]{cStart, cEnd};
        RadialGradientPaint p = new RadialGradientPaint(cent, (float)radius, dist, cols, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        g2d.setPaint(p);
        g2d.fill(slice.getSlicePath());
    }
}

