/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie.painter.label;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.text.DecimalFormat;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.plugin.pie.Pie;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.painter.AbstractPieSlicePainter;

public abstract class AbstractPieSliceLabel
extends AbstractPieSlicePainter {
    private String label;
    private Color labelColor;
    private Font labelFont;
    private int labelPaddingX = 10;
    private int labelPaddingY = 2;
    private int outlineRound = 20;
    private Color outlineColor;
    private Stroke outlineStroke;
    private Color fillColor;
    private float[] shadeFractions;
    private Color[] shadeColors;
    private Stroke defaultStroke = new BasicStroke();
    private Style style = Style.Both;
    private DecimalFormat decimalFormat = new DecimalFormat("##.##");

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font labelFont) {
        this.labelFont = labelFont;
    }

    public void setShader(float[] fractions, Color[] colors) {
        if (fractions.length != colors.length) {
            throw new IllegalArgumentException("length array does not match");
        }
        this.shadeFractions = fractions;
        this.shadeColors = colors;
    }

    public void setShader(Shader shader) {
        if (shader != null) {
            this.shadeFractions = shader.getFractions();
            this.shadeColors = shader.getColors();
        }
    }

    public Shader getShader() {
        if (this.shadeFractions != null && this.shadeColors != null) {
            return new Shader(this.shadeFractions, this.shadeColors);
        }
        return null;
    }

    public int getLabelPaddingX() {
        return this.labelPaddingX;
    }

    public void setLabelPaddingX(int labelPaddingX) {
        this.labelPaddingX = labelPaddingX;
    }

    public int getLabelPaddingY() {
        return this.labelPaddingY;
    }

    public void setLabelPaddingY(int labelPaddingY) {
        this.labelPaddingY = labelPaddingY;
    }

    public int getOutlineRound() {
        return this.outlineRound;
    }

    public void setOutlineRound(int outlineRound) {
        this.outlineRound = outlineRound;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke outlineStroke) {
        this.outlineStroke = outlineStroke;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public float[] getShadeFractions() {
        return this.shadeFractions;
    }

    public void setShadeFractions(float[] shadeFractions) {
        this.shadeFractions = shadeFractions;
    }

    public Color[] getShadeColors() {
        return this.shadeColors;
    }

    public void setShadeColors(Color[] shadeColors) {
        this.shadeColors = shadeColors;
    }

    public Stroke getDefaultStroke() {
        return this.defaultStroke;
    }

    public DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    public void setDecimalFormat(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public void setDefaultStroke(Stroke defaultStroke) {
        this.defaultStroke = defaultStroke;
    }

    protected abstract void paintPieLabel(Graphics2D var1, Pie var2, PieSlice var3);

    @Override
    public final void paintPieSlice(Graphics2D g2d, Pie pie, PieSlice slice) {
        g2d.setComposite(AlphaComposite.getInstance(3, slice.getAlpha()));
        if (slice.getPercent() * 100.0 > pie.getPassiveLabelAtMinPercent()) {
            this.paintPieLabel(g2d, pie, slice);
        }
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    public static enum Style {
        Nothing("Nothing"),
        Stroke("Stroke"),
        Fill("Fill"),
        Both("Both");

        private String styleName;

        private Style(String style) {
            this.styleName = style;
        }

        public String getStyleName() {
            return this.styleName;
        }

        public static Style parseStyle(String style) {
            if (Nothing.getStyleName().equalsIgnoreCase(style)) {
                return Nothing;
            }
            if (Stroke.getStyleName().equalsIgnoreCase(style)) {
                return Stroke;
            }
            if (Fill.getStyleName().equalsIgnoreCase(style)) {
                return Fill;
            }
            if (Both.getStyleName().equalsIgnoreCase(style)) {
                return Both;
            }
            return Both;
        }
    }
}

