/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie.painter.label;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import org.jensoft.core.drawable.text.TextPath;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.palette.color.ColorPalette;
import org.jensoft.core.palette.color.RosePalette;
import org.jensoft.core.palette.color.TangoPalette;
import org.jensoft.core.plugin.PluginPlatform;
import org.jensoft.core.plugin.pie.Pie;
import org.jensoft.core.plugin.pie.PiePlugin;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.PieToolkit;
import org.jensoft.core.plugin.pie.animator.PieDivergenceAnimator;
import org.jensoft.core.plugin.pie.painter.effect.PieLinearEffect;
import org.jensoft.core.plugin.pie.painter.label.AbstractPieSliceLabel;
import org.jensoft.core.plugin.pie.painter.label.PieBorderLabel;
import org.jensoft.core.plugin.pie.painter.label.PieBoundLabel;
import org.jensoft.core.plugin.pie.painter.label.PiePathLabel;
import org.jensoft.core.plugin.pie.painter.label.PieRadialLabel;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.Portfolio;
import org.jensoft.core.view.View;
import org.jensoft.core.view.background.ViewDefaultBackground;

public class JavadocPortfolioPie {
    @Portfolio(name="PieRadialLabel", width=800, height=800)
    public static View getPieRadialLabel() {
        View view = new View(0);
        Projection.Linear proj = new Projection.Linear(-1.0, 1.0, -1.0, 1.0);
        proj.setName("compatible donut3D");
        view.registerProjection(proj);
        PiePlugin piePlugin = new PiePlugin();
        proj.registerPlugin(piePlugin);
        Pie pie = PieToolkit.createPie("pie", 60.0);
        pie.setStartAngleDegree(20.0);
        PieLinearEffect fx1 = new PieLinearEffect(120);
        fx1.setOffsetRadius(5);
        pie.setPieEffect(fx1);
        PieSlice s1 = PieToolkit.createSlice("gray", new Color(240, 240, 240, 240), 45.0, 0);
        PieSlice s2 = PieToolkit.createSlice("gray", ColorPalette.alpha(TangoPalette.BUTTER2, 240), 5.0, 0);
        PieSlice s3 = PieToolkit.createSlice("chameleon", ColorPalette.alpha(TangoPalette.CHAMELEON2, 240), 30.0, 0);
        PieSlice s4 = PieToolkit.createSlice("blue", ColorPalette.alpha(TangoPalette.SKYBLUE2, 240), 20.0, 0);
        PieToolkit.pushSlices(pie, s1, s2, s3, s4);
        piePlugin.addPie(pie);
        pie.addPieAnimator(new PieDivergenceAnimator());
        float[] fractions = new float[]{0.0f, 0.5f, 1.0f};
        Color[] colors = new Color[]{new Color(0, 0, 0, 100), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255)};
        BasicStroke s = new BasicStroke(2.0f);
        pie.setPassiveLabelAtMinPercent(0.0);
        Font f = new Font("Dialog", 0, 12);
        PieRadialLabel label1 = PieToolkit.createRadialLabel("Symbian", ColorPalette.WHITE, f, 20);
        label1.setStyle(AbstractPieSliceLabel.Style.Both);
        label1.setOutlineStroke(s);
        label1.setShader(fractions, colors);
        label1.setOutlineColor(RosePalette.REDWOOD);
        label1.setOutlineRound(20);
        s1.addSliceLabel(label1);
        PieRadialLabel label2 = PieToolkit.createRadialLabel("WiMo", ColorPalette.WHITE, f, 20);
        label2.setStyle(AbstractPieSliceLabel.Style.Both);
        label2.setOutlineStroke(s);
        label2.setShader(fractions, colors);
        label2.setOutlineColor(RosePalette.LIME);
        label2.setOutlineRound(20);
        s2.addSliceLabel(label2);
        PieRadialLabel label3 = PieToolkit.createRadialLabel("iPhone", ColorPalette.WHITE, f, 20);
        label3.setStyle(AbstractPieSliceLabel.Style.Both);
        label3.setOutlineStroke(s);
        label3.setShader(fractions, colors);
        label3.setOutlineColor(RosePalette.EMERALD);
        label3.setOutlineRound(20);
        s3.addSliceLabel(label3);
        PieRadialLabel label4 = PieToolkit.createRadialLabel("Android", ColorPalette.WHITE, f, 20);
        label4.setStyle(AbstractPieSliceLabel.Style.Both);
        label4.setOutlineStroke(s);
        label4.setOutlineColor(RosePalette.COBALT);
        label4.setShader(fractions, colors);
        label4.setOutlineRound(20);
        s4.addSliceLabel(label4);
        return view;
    }

    @Portfolio(name="PiePathLabel", width=800, height=800)
    public static View createView() {
        View view = new View(0);
        Projection.Linear proj = new Projection.Linear(-1.0, 1.0, -1.0, 1.0);
        proj.setName("compatible donut3D window");
        view.registerProjection(proj);
        PiePlugin piePlugin = new PiePlugin();
        proj.registerPlugin(piePlugin);
        ViewDefaultBackground viewBackground = new ViewDefaultBackground();
        Shader sb = new Shader(new float[]{0.0f, 1.0f}, new Color[]{new Color(32, 39, 55), Color.BLACK});
        viewBackground.setShader(sb);
        viewBackground.setOutlineStroke(new BasicStroke(2.5f));
        view.setBackgroundPainter(viewBackground);
        Pie pie = PieToolkit.createPie("pie", 90.0);
        pie.setPieEffect(new PieLinearEffect());
        PieSlice s1 = PieToolkit.createSlice("gray", new Color(240, 240, 240, 240), 45.0, 0);
        PieSlice s2 = PieToolkit.createSlice("gray", ColorPalette.alpha(TangoPalette.BUTTER2, 240), 5.0, 0);
        PieSlice s3 = PieToolkit.createSlice("chameleon", ColorPalette.alpha(TangoPalette.CHAMELEON2, 240), 30.0, 0);
        PieSlice s4 = PieToolkit.createSlice("blue", ColorPalette.alpha(TangoPalette.SKYBLUE2, 240), 20.0, 0);
        PieToolkit.pushSlices(pie, s1, s2, s3, s4);
        piePlugin.addPie(pie);
        pie.addPieAnimator(new PieDivergenceAnimator());
        PiePathLabel ppl = new PiePathLabel(TextPath.TextPosition.Right, "My name is S\ufffdbastien");
        ppl.setPathSide(TextPath.PathSide.Below);
        Font f = new Font("Dialog", 0, 12);
        ppl.setLabelFont(f);
        ppl.setLabelColor(RosePalette.MANDARIN);
        ppl.setDivergence(2);
        s1.addSliceLabel(ppl);
        PiePathLabel ppl12 = PieToolkit.createPathLabel("JenSoft API", RosePalette.INDIGO, f, TextPath.TextPosition.Middle);
        s1.addSliceLabel(ppl12);
        PiePathLabel ppl3 = new PiePathLabel(TextPath.TextPosition.Left, "Pie Path Label", TangoPalette.CHAMELEON2.darker());
        float[] fractions = new float[]{0.0f, 1.0f};
        Color[] colors = new Color[]{Color.BLACK, RosePalette.AMETHYST};
        ppl3.setLabelFont(f);
        ppl3.setTextShader(fractions, colors);
        ppl3.setPathSide(TextPath.PathSide.Above);
        ppl3.setDivergence(2);
        s3.addSliceLabel(ppl3);
        PiePathLabel ppl4 = new PiePathLabel(TextPath.TextPosition.Right, "JenSoft");
        ppl4.setPathSide(TextPath.PathSide.Below);
        ppl4.setLabelFont(f);
        ppl4.setDivergence(0);
        return view;
    }

    @Portfolio(name="PieBoundLabel", width=800, height=800)
    public static View getPieBoundLabel() {
        View view = new View(0);
        Projection.Linear proj = new Projection.Linear(-1.0, 1.0, -1.0, 1.0);
        proj.setName("compatible donut3D window");
        view.registerProjection(proj);
        PiePlugin piePlugin = new PiePlugin();
        proj.registerPlugin(piePlugin);
        ViewDefaultBackground viewBackground = new ViewDefaultBackground();
        Shader sb = new Shader(new float[]{0.0f, 1.0f}, new Color[]{new Color(32, 39, 55), Color.BLACK});
        viewBackground.setShader(sb);
        viewBackground.setOutlineStroke(new BasicStroke(2.5f));
        view.setBackgroundPainter(viewBackground);
        Pie pie = PieToolkit.createPie("pie", 80.0);
        pie.setPieEffect(new PieLinearEffect());
        PieSlice s1 = PieToolkit.createSlice("gray", new Color(240, 240, 240, 240), 45.0, 0);
        PieSlice s2 = PieToolkit.createSlice("gray", ColorPalette.alpha(TangoPalette.BUTTER2, 240), 5.0, 0);
        PieSlice s3 = PieToolkit.createSlice("chameleon", ColorPalette.alpha(TangoPalette.CHAMELEON2, 240), 30.0, 0);
        PieSlice s4 = PieToolkit.createSlice("blue", ColorPalette.alpha(TangoPalette.SKYBLUE2, 240), 20.0, 0);
        PieToolkit.pushSlices(pie, s1, s2, s3, s4);
        piePlugin.addPie(pie);
        pie.addPieAnimator(new PieDivergenceAnimator());
        float[] fractions = new float[]{0.0f, 0.5f, 1.0f};
        Color[] colors = new Color[]{new Color(0, 0, 0, 100), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255)};
        BasicStroke s = new BasicStroke(2.0f);
        pie.setPassiveLabelAtMinPercent(0.0);
        Font f = new Font("Dialog", 0, 10);
        PieBoundLabel label1 = PieToolkit.createBoundLabel("Symbian", ColorPalette.WHITE, f);
        label1.setStyle(AbstractPieSliceLabel.Style.Both);
        label1.setOutlineStroke(s);
        label1.setShader(fractions, colors);
        label1.setOutlineColor(RosePalette.REDWOOD);
        label1.setOutlineRound(20);
        s1.addSliceLabel(label1);
        PieBoundLabel label2 = PieToolkit.createBoundLabel("Wimo", ColorPalette.WHITE, f);
        label2.setStyle(AbstractPieSliceLabel.Style.Both);
        label2.setOutlineStroke(s);
        label2.setShader(fractions, colors);
        label2.setOutlineColor(RosePalette.LIME);
        label2.setOutlineRound(20);
        s2.addSliceLabel(label2);
        PieBoundLabel label3 = PieToolkit.createBoundLabel("IPhone", ColorPalette.WHITE, f);
        label3.setStyle(AbstractPieSliceLabel.Style.Both);
        label3.setOutlineStroke(s);
        label3.setShader(fractions, colors);
        label3.setOutlineColor(RosePalette.EMERALD);
        label3.setOutlineRound(20);
        s3.addSliceLabel(label3);
        PieBoundLabel label4 = PieToolkit.createBoundLabel("Android", ColorPalette.WHITE, f);
        label4.setStyle(AbstractPieSliceLabel.Style.Both);
        label4.setOutlineStroke(s);
        label4.setShader(fractions, colors);
        label4.setOutlineColor(RosePalette.AEGEANBLUE);
        label4.setOutlineRound(20);
        s4.addSliceLabel(label4);
        return view;
    }

    @Portfolio(name="PieBorderLabel", width=800, height=800)
    public static View getPieBorderLabel() {
        View view = new View(0);
        Projection.Linear proj = new Projection.Linear(-1.0, 1.0, -1.0, 1.0);
        proj.setName("compatible donut3D window");
        view.registerProjection(proj);
        PiePlugin piePlugin = new PiePlugin();
        proj.registerPlugin(piePlugin);
        ViewDefaultBackground viewBackground = new ViewDefaultBackground();
        Shader sb = new Shader(new float[]{0.0f, 1.0f}, new Color[]{new Color(32, 39, 55), Color.BLACK});
        viewBackground.setShader(sb);
        viewBackground.setOutlineStroke(new BasicStroke(2.5f));
        view.setBackgroundPainter(viewBackground);
        Pie pie = PieToolkit.createPie("pie", 60.0);
        pie.setPieEffect(new PieLinearEffect());
        PieSlice s1 = PieToolkit.createSlice("s1", new Color(240, 240, 240, 240), 45.0, 0);
        PieSlice s2 = PieToolkit.createSlice("s2", ColorPalette.alpha(TangoPalette.BUTTER2, 240), 5.0, 0);
        PieSlice s3 = PieToolkit.createSlice("s3", ColorPalette.alpha(TangoPalette.CHAMELEON2, 240), 30.0, 0);
        PieSlice s4 = PieToolkit.createSlice("s4", ColorPalette.alpha(TangoPalette.SKYBLUE2, 240), 20.0, 0);
        PieToolkit.pushSlices(pie, s1, s2, s3, s4);
        piePlugin.addPie(pie);
        pie.setPassiveLabelAtMinPercent(18.0);
        float[] fractions = new float[]{0.0f, 0.5f, 1.0f};
        Color[] colors = new Color[]{new Color(0, 0, 0, 100), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255)};
        BasicStroke s = new BasicStroke(2.0f);
        pie.setPassiveLabelAtMinPercent(0.0);
        Font f = new Font("Dialog", 0, 10);
        PieBorderLabel label1 = PieToolkit.createBorderLabel("View", ColorPalette.WHITE, f, 30);
        label1.setStyle(AbstractPieSliceLabel.Style.Both);
        label1.setOutlineStroke(s);
        label1.setShader(fractions, colors);
        label1.setOutlineColor(RosePalette.REDWOOD);
        label1.setOutlineRound(20);
        label1.setLinkColor(RosePalette.REDWOOD);
        label1.setLinkStyle(PieBorderLabel.LinkStyle.Quad);
        label1.setLinkExtends(40);
        label1.setMargin(50);
        s1.addSliceLabel(label1);
        PieBorderLabel label2 = PieToolkit.createBorderLabel("Window", ColorPalette.WHITE, f, 30);
        label2.setStyle(AbstractPieSliceLabel.Style.Both);
        label2.setOutlineStroke(s);
        label2.setShader(fractions, colors);
        label2.setOutlineColor(RosePalette.LIME);
        label2.setOutlineRound(20);
        label2.setLinkColor(RosePalette.LIME);
        label2.setLinkExtends(40);
        label2.setLinkStyle(PieBorderLabel.LinkStyle.Quad);
        label2.setMargin(50);
        s2.addSliceLabel(label2);
        PieBorderLabel label3 = PieToolkit.createBorderLabel("plugin", ColorPalette.WHITE, f, 30);
        label3.setStyle(AbstractPieSliceLabel.Style.Both);
        label3.setOutlineStroke(s);
        label3.setShader(fractions, colors);
        label3.setOutlineColor(RosePalette.EMERALD);
        label3.setOutlineRound(20);
        label3.setLinkColor(RosePalette.EMERALD);
        label3.setLinkStyle(PieBorderLabel.LinkStyle.Quad);
        label3.setLinkExtends(40);
        label3.setMargin(50);
        s3.addSliceLabel(label3);
        PieBorderLabel label4 = PieToolkit.createBorderLabel("widget", ColorPalette.WHITE, f, 30);
        label4.setStyle(AbstractPieSliceLabel.Style.Both);
        label4.setOutlineStroke(s);
        label4.setOutlineColor(RosePalette.COBALT);
        label4.setShader(fractions, colors);
        label4.setOutlineRound(20);
        label4.setLinkColor(RosePalette.COBALT);
        label4.setLinkStyle(PieBorderLabel.LinkStyle.Quad);
        label4.setLinkExtends(40);
        label4.setMargin(50);
        s4.addSliceLabel(label4);
        return view;
    }

    public void render() {
        String packageName = this.getClass().getPackage().getName();
        String packagePath = packageName.replace('.', File.separatorChar);
        String docFilePath = System.getProperty("user.dir") + File.separator + "src" + File.separator + packagePath + File.separator + "doc-files";
        PluginPlatform.createPortfolio(packageName, docFilePath, 400, 280);
    }

    public static void main(String[] args) {
        JavadocPortfolioPie docFilePortfolio = new JavadocPortfolioPie();
        docFilePortfolio.render();
    }
}

