/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie.painter.label;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import org.jensoft.core.drawable.text.TextPath;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.plugin.pie.Pie;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.painter.label.AbstractPieSliceLabel;

public class PiePathLabel
extends AbstractPieSliceLabel {
    private TextPath.TextPosition textPosition = TextPath.TextPosition.Left;
    private TextPath.PathSide pathSide = TextPath.PathSide.Above;
    private float[] fractions;
    private Color[] colors;
    private int divergence = 10;
    private PathName pathName = PathName.Arc;
    private boolean lockReverse = false;
    private boolean autoReverse = true;
    private int offsetRight = 10;
    private int offsetLeft = 10;

    public PiePathLabel() {
    }

    public PiePathLabel(TextPath.TextPosition textPosition) {
        this.textPosition = textPosition;
    }

    public PiePathLabel(String label) {
        super.setLabel(label);
    }

    public PiePathLabel(String label, Color labelColor) {
        super.setLabel(label);
        super.setLabelColor(labelColor);
    }

    public PiePathLabel(String label, Color labelColor, Font labelFont) {
        super.setLabel(label);
        super.setLabelColor(labelColor);
        super.setLabelFont(labelFont);
    }

    public PiePathLabel(TextPath.TextPosition textPosition, String label) {
        this.textPosition = textPosition;
        super.setLabel(label);
    }

    public PiePathLabel(TextPath.TextPosition textPosition, String label, Color labelColor) {
        this.textPosition = textPosition;
        super.setLabel(label);
        super.setLabelColor(labelColor);
    }

    public boolean isLockReverse() {
        return this.lockReverse;
    }

    public void setLockReverse(boolean lockReverse) {
        this.lockReverse = lockReverse;
    }

    public boolean isAutoReverse() {
        return this.autoReverse;
    }

    public void setAutoReverse(boolean autoReverse) {
        this.autoReverse = autoReverse;
    }

    public int getOffsetRight() {
        return this.offsetRight;
    }

    public void setOffsetRight(int offsetRight) {
        this.offsetRight = offsetRight;
    }

    public int getOffsetLeft() {
        return this.offsetLeft;
    }

    public void setOffsetLeft(int offsetLeft) {
        this.offsetLeft = offsetLeft;
    }

    public PathName getPathName() {
        return this.pathName;
    }

    public void setPathName(PathName pathName) {
        this.pathName = pathName;
    }

    public TextPath.TextPosition getTextPosition() {
        return this.textPosition;
    }

    public void setTextPosition(TextPath.TextPosition textPosition) {
        this.textPosition = textPosition;
    }

    public TextPath.PathSide getPathSide() {
        return this.pathSide;
    }

    public void setPathSide(TextPath.PathSide pathSide) {
        this.pathSide = pathSide;
    }

    public int getDivergence() {
        return this.divergence;
    }

    public void setDivergence(int divergence) {
        this.divergence = divergence;
    }

    public void setTextShader(float[] fractions, Color[] colors) {
        if (fractions.length != colors.length) {
            throw new IllegalArgumentException("colors and fractions length array does not match");
        }
        this.fractions = fractions;
        this.colors = colors;
    }

    public void setTextShader(Shader shader) {
        if (shader != null) {
            this.fractions = shader.getFractions();
            this.colors = shader.getColors();
        }
    }

    @Override
    protected void paintPieLabel(Graphics2D g2d, Pie pie, PieSlice pieSection) {
        TextPath pt = null;
        if (this.pathName == PathName.Arc) {
            pt = new TextPath(pieSection.getExternalArc());
        }
        if (this.pathName == PathName.Start) {
            pt = new TextPath(pieSection.getLineStart());
        }
        if (this.pathName == PathName.End) {
            pt = new TextPath(pieSection.getLineEnd());
        }
        if (pt != null) {
            pt.setTextPosition(this.textPosition);
            pt.setLockReverse(this.isLockReverse());
            pt.setAutoReverse(this.isAutoReverse());
            pt.setLabel(this.getLabel());
            pt.setTextColor(this.getLabelColor());
            pt.setOffsetRight(this.getOffsetRight());
            pt.setOffsetLeft(this.getOffsetLeft());
            pt.setLabelFont(this.getLabelFont());
            pt.setPathSide(this.pathSide);
            pt.setDivergence(this.divergence);
            if (this.fractions != null && this.colors != null && this.fractions.length == this.colors.length) {
                pt.setShader(this.fractions, this.colors);
            }
            pt.draw(g2d);
        }
    }

    public static enum PathName {
        Start("Start"),
        Arc("Arc"),
        End("End");

        private String pathName;

        private PathName(String path) {
            this.pathName = path;
        }

        public String getPathName() {
            return this.pathName;
        }

        public static PathName parse(String path) {
            if (Start.getPathName().equals(path)) {
                return Start;
            }
            if (Arc.getPathName().equals(path)) {
                return Arc;
            }
            if (End.getPathName().equals(path)) {
                return End;
            }
            return Arc;
        }
    }
}

