/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie.painter.label;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.jensoft.core.plugin.pie.Pie;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.painter.label.AbstractPieSliceLabel;

public class PieRadialLabel
extends AbstractPieSliceLabel {
    private int offsetRadius = 20;

    public PieRadialLabel() {
    }

    public PieRadialLabel(String label, Color labelColor, Font labelFont) {
        super.setLabel(label);
        super.setLabelColor(labelColor);
        super.setLabelFont(labelFont);
    }

    public PieRadialLabel(String label, Color labelColor) {
        this(label, labelColor, null);
    }

    public PieRadialLabel(String label) {
        this(label, null, null);
    }

    public int getOffsetRadius() {
        return this.offsetRadius;
    }

    public void setOffsetRadius(int offsetRadius) {
        this.offsetRadius = offsetRadius;
    }

    @Override
    protected void paintPieLabel(Graphics2D g2d, Pie pie, PieSlice pieSection) {
        g2d.setColor(pieSection.getThemeColor());
        double percent = pieSection.getPercent() * 100.0;
        String s = this.getDecimalFormat().format(percent) + "%";
        if (this.getLabel() != null) {
            s = this.getLabel();
        }
        Font f = new Font("Dialog", 0, 12);
        if (this.getLabelFont() != null) {
            f = this.getLabelFont();
        }
        g2d.setFont(f);
        FontMetrics fm = g2d.getFontMetrics();
        int widthText = fm.stringWidth(s);
        int heightText = fm.getHeight();
        int ascentText = fm.getAscent();
        int descentText = fm.getDescent();
        double centerX = pie.getCenterX();
        double centerY = pie.getCenterY();
        Point2D c = null;
        if (pie.getPieNature() == Pie.PieNature.User) {
            c = pie.getHostPlugin().getProjection().userToPixel(new Point2D.Double(centerX, centerY));
        }
        if (pie.getPieNature() == Pie.PieNature.Device) {
            c = new Point2D.Double(centerX, centerY);
        }
        centerX = c.getX();
        centerY = c.getY();
        double radius = pie.getRadius();
        double medianDegree = pieSection.getMedianAngleDegree();
        if (medianDegree >= 360.0) {
            medianDegree -= 360.0;
        }
        double px2 = c.getX() + (radius + (double)this.offsetRadius + (double)pieSection.getDivergence()) * Math.cos(Math.toRadians(medianDegree));
        double py2 = c.getY() - (radius + (double)this.offsetRadius + (double)pieSection.getDivergence()) * Math.sin(Math.toRadians(medianDegree));
        if (medianDegree >= 270.0 && medianDegree <= 360.0 || medianDegree >= 0.0 && medianDegree <= 90.0) {
            py2 = (float)(py2 + (double)(fm.getAscent() / 2));
        } else {
            px2 = (float)(px2 - (double)widthText);
            py2 = (float)(py2 + (double)(fm.getAscent() / 2));
        }
        g2d.setColor(pieSection.getThemeColor());
        g2d.setStroke(this.getDefaultStroke());
        float x = (float)px2;
        float y = (float)py2;
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(x - (float)this.getLabelPaddingX(), y - (float)ascentText - (float)this.getLabelPaddingY(), widthText + 2 * this.getLabelPaddingX(), ascentText + descentText + 2 * this.getLabelPaddingY(), this.getOutlineRound(), this.getOutlineRound());
        if (this.getStyle() == AbstractPieSliceLabel.Style.Fill || this.getStyle() == AbstractPieSliceLabel.Style.Both) {
            if (this.getFillColor() != null && this.getShadeFractions() == null) {
                g2d.setColor(this.getFillColor());
                g2d.fill(rect);
            }
            if (this.getFillColor() != null && this.getShadeFractions() == null) {
                g2d.setColor(pieSection.getThemeColor());
            }
            Point2D.Double start2 = new Point2D.Double(((RectangularShape)rect).getX(), ((RectangularShape)rect).getY() + ((RectangularShape)rect).getHeight());
            Point2D.Double end2 = new Point2D.Double(((RectangularShape)rect).getX(), ((RectangularShape)rect).getY());
            float[] dist2 = new float[]{0.0f, 0.4f, 0.6f, 1.0f};
            Color cStart2 = new Color(40, 40, 40, 80);
            Color cStart2bis = new Color(40, 40, 40, 10);
            Color cEnd2bis = new Color(255, 255, 255, 10);
            Color cEnd2 = new Color(240, 240, 240, 80);
            Color[] colors2 = new Color[]{cStart2, cStart2bis, cEnd2bis, cEnd2};
            if (this.getShadeFractions() != null && this.getShadeColors() != null) {
                colors2 = this.getShadeColors();
                dist2 = this.getShadeFractions();
            }
            if (!start2.equals(end2)) {
                LinearGradientPaint p2 = new LinearGradientPaint(start2, end2, dist2, colors2);
                g2d.setPaint(p2);
                g2d.fill(rect);
            }
        }
        if (this.getStyle() == AbstractPieSliceLabel.Style.Stroke || this.getStyle() == AbstractPieSliceLabel.Style.Both) {
            if (this.getOutlineColor() != null) {
                g2d.setColor(this.getOutlineColor());
            } else {
                g2d.setColor(pieSection.getThemeColor().brighter());
            }
            if (this.getOutlineStroke() != null) {
                g2d.setStroke(this.getOutlineStroke());
            }
            g2d.draw(rect);
        }
        g2d.setColor(pieSection.getThemeColor());
        g2d.setStroke(this.getDefaultStroke());
        g2d.setColor(pieSection.getThemeColor().brighter());
        if (this.getLabelColor() != null) {
            g2d.setColor(this.getLabelColor());
        }
        g2d.drawString(s, x, y);
    }
}

