/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.plot;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.jensoft.core.device.ContextEntry;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.plot.spline.AbstractPlot;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class PlotAnchorsPlugin
extends AbstractPlugin
implements AbstractPlugin.OnPressListener,
AbstractPlugin.OnReleaseListener,
AbstractPlugin.OnDragListener {
    private List<AbstractPlot> plots = new ArrayList<AbstractPlot>();
    private AbstractPlot selectedPlot = null;
    private Map<String, AbstractPlot> mapping = new HashMap<String, AbstractPlot>();

    public PlotAnchorsPlugin() {
        this.registerContext(new PlotAnchorContext());
        this.setOnPressListener(this);
        this.setOnReleaseListener(this);
        this.setOnDragListener(this);
    }

    private void selectPlot(String key) {
        this.selectedPlot = this.mapping.get(key);
    }

    public void addPlot(AbstractPlot plot) {
        this.plots.add(plot);
    }

    @Override
    public void onRelease(MouseEvent me) {
        if (me.isShiftDown()) {
            this.selectedPlot.removePoint();
            this.getProjection().getView().repaintDevice();
        }
    }

    @Override
    public void onDrag(MouseEvent me) {
        if (this.selectedPlot != null) {
            this.selectedPlot.updateAnchorPoint(me.getX(), me.getY());
            this.getProjection().getView().repaintDevice();
        }
    }

    @Override
    public void onPress(MouseEvent me) {
        if (this.selectedPlot != null) {
            this.selectedPlot.selectPlotAnchor(me.getX(), me.getY());
        }
    }

    @Override
    protected void paintPlugin(View v2d, Graphics2D g2d, ViewPart viewPart) {
    }

    class PlotAnchorContext
    extends ContextEntry<PlotAnchorsPlugin> {
        PlotAnchorContext() {
        }

        @Override
        public void buildContext() {
            JMenu plotAnchorRoot = new JMenu("Plot Anchor");
            int count = 0;
            PlotAnchorsPlugin.this.mapping.clear();
            for (AbstractPlot plot : PlotAnchorsPlugin.this.plots) {
                JMenuItem itemPlot = new JMenuItem("Plot-" + count);
                int callbackIndex = count++;
                final String key = "Plot-" + callbackIndex;
                PlotAnchorsPlugin.this.mapping.put(key, plot);
                itemPlot.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PlotAnchorsPlugin.this.selectPlot(key);
                    }
                });
                plotAnchorRoot.add(itemPlot);
            }
            this.setGroup("Plot");
            this.setItem(plotAnchorRoot);
        }

        @Override
        public boolean isCompatiblePlugin() {
            return true;
        }
    }
}

