/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.plot.applet;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import org.jensoft.core.plugin.plot.applet.ControlCurve;

public class Bezier
extends ControlCurve {
    final int STEPS = 12;

    static float b(int i, float t) {
        switch (i) {
            case 0: {
                return (1.0f - t) * (1.0f - t) * (1.0f - t);
            }
            case 1: {
                return 3.0f * t * (1.0f - t) * (1.0f - t);
            }
            case 2: {
                return 3.0f * t * t * (1.0f - t);
            }
            case 3: {
                return t * t * t;
            }
        }
        return 0.0f;
    }

    Point p(int i, float t) {
        float px = 0.0f;
        float py = 0.0f;
        for (int j = 0; j <= 3; ++j) {
            px += Bezier.b(j, t) * (float)this.pts.xpoints[i + j];
            py += Bezier.b(j, t) * (float)this.pts.ypoints[i + j];
        }
        return new Point(Math.round(px), Math.round(py));
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Polygon pol = new Polygon();
        Point q = this.p(0, 0.0f);
        pol.addPoint(q.x, q.y);
        for (int i = 0; i < this.pts.npoints - 3; i += 3) {
            for (int j = 1; j <= 12; ++j) {
                q = this.p(i, (float)j / 12.0f);
                pol.addPoint(q.x, q.y);
            }
        }
        g.drawPolyline(pol.xpoints, pol.ypoints, pol.npoints);
    }
}

