/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.plot.applet;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;

public class ControlCurve {
    protected Polygon pts = new Polygon();
    protected int selection = -1;
    static Font f = new Font("Courier", 0, 12);
    static final int EPSILON = 36;

    public void paint(Graphics g) {
        FontMetrics fm = g.getFontMetrics(f);
        g.setFont(f);
        int h = fm.getAscent() / 2;
        for (int i = 0; i < this.pts.npoints; ++i) {
            String s = Integer.toString(i);
            int w = fm.stringWidth(s) / 2;
            g.drawString(Integer.toString(i), this.pts.xpoints[i] - w, this.pts.ypoints[i] + h);
        }
    }

    public int selectPoint(int x, int y) {
        int mind = Integer.MAX_VALUE;
        this.selection = -1;
        for (int i = 0; i < this.pts.npoints; ++i) {
            int d = ControlCurve.sqr(this.pts.xpoints[i] - x) + ControlCurve.sqr(this.pts.ypoints[i] - y);
            if (d >= mind || d >= 36) continue;
            mind = d;
            this.selection = i;
        }
        return this.selection;
    }

    static int sqr(int x) {
        return x * x;
    }

    public int addPoint(int x, int y) {
        this.pts.addPoint(x, y);
        this.selection = this.pts.npoints - 1;
        return this.selection;
    }

    public void setPoint(int x, int y) {
        if (this.selection >= 0) {
            this.pts.xpoints[this.selection] = x;
            this.pts.ypoints[this.selection] = y;
        }
    }

    public void removePoint() {
        if (this.selection >= 0) {
            --this.pts.npoints;
            for (int i = this.selection; i < this.pts.npoints; ++i) {
                this.pts.xpoints[i] = this.pts.xpoints[i + 1];
                this.pts.ypoints[i] = this.pts.ypoints[i + 1];
            }
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.pts.npoints; ++i) {
            result.append(" " + this.pts.xpoints[i] + " " + this.pts.ypoints[i]);
        }
        return result.toString();
    }
}

