/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.plot.applet;

import java.awt.Canvas;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import org.jensoft.core.plugin.plot.applet.ControlCurve;
import org.jensoft.core.plugin.plot.applet.MouseEvent;

public class CurveCanvas
extends Canvas
implements Runnable {
    Image offscreen;
    ControlCurve curve;
    MouseEvent mouseEvent;

    public CurveCanvas(MouseEvent mouseEvent, ControlCurve curve) {
        this.mouseEvent = mouseEvent;
        this.curve = curve;
    }

    @Override
    public void paint(Graphics g) {
        if (this.offscreen == null) {
            this.offscreen = this.createImage(this.size().width, this.size().height);
        }
        Graphics og = this.offscreen.getGraphics();
        og.clearRect(0, 0, this.size().width, this.size().height);
        this.curve.paint(og);
        g.drawImage(this.offscreen, 0, 0, null);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public void update() {
        this.update(this.getGraphics());
    }

    @Override
    public void run() {
        while (true) {
            Event e = this.mouseEvent.get();
            if (e.id == 501) {
                if (this.curve.selectPoint(e.x, e.y) != -1) continue;
                this.curve.addPoint(e.x, e.y);
                this.update();
                continue;
            }
            if (e.id == 506) {
                this.curve.setPoint(e.x, e.y);
                this.update();
                continue;
            }
            if (e.id != 502 || !e.shiftDown()) continue;
            this.curve.removePoint();
            this.update();
        }
    }
}

