/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.plot.applet;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Event;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.jensoft.core.plugin.plot.applet.BezierG1;
import org.jensoft.core.plugin.plot.applet.ControlCurve;
import org.jensoft.core.plugin.plot.applet.CurveCanvas;
import org.jensoft.core.plugin.plot.applet.MouseEvent;

public class SplineApplet
extends Applet {
    protected ControlCurve curve;
    protected Color bgcolor;
    protected MouseEvent mouseEvent;

    @Override
    public void init() {
        Color bgcolor = this.getColorParameter("bgcolor", null);
        if (bgcolor != null) {
            this.setBackground(bgcolor);
        }
        this.curve = new BezierG1();
        String s = this.getParameter("controlPoints");
        if (s != null) {
            StringTokenizer st = new StringTokenizer(s, " \t");
            try {
                while (st.hasMoreTokens()) {
                    int x = Integer.parseInt(st.nextToken());
                    int y = Integer.parseInt(st.nextToken());
                    this.curve.addPoint(x, y);
                }
            }
            catch (NoSuchElementException e) {
                System.err.println("Bad controlPoints parameter " + e.getMessage());
            }
            catch (NumberFormatException e) {
                System.err.println("Bad controlPoints parameter " + e.getMessage());
            }
        }
        this.setLayout(new BorderLayout(0, 0));
        this.mouseEvent = new MouseEvent();
        CurveCanvas canvas = new CurveCanvas(this.mouseEvent, this.curve);
        this.add("Center", canvas);
        Thread canvasThread = new Thread(canvas);
        canvasThread.start();
        canvasThread.setPriority(1);
    }

    @Override
    public boolean handleEvent(Event e) {
        if (e.id == 501 || e.id == 506 || e.id == 502) {
            this.mouseEvent.put(e);
            return true;
        }
        return false;
    }

    protected Color getColorParameter(String name, Color dfault) {
        int intvalue;
        String value = this.getParameter(name);
        try {
            intvalue = Integer.parseInt(value, 16);
        }
        catch (NumberFormatException e) {
            return dfault;
        }
        return new Color(intvalue);
    }
}

