/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.plot.painter.label;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import org.jensoft.core.plugin.plot.painter.label.AbstractPlotLabel;
import org.jensoft.core.plugin.plot.spline.AbstractPlot;

public class PlotDefaultLabel
extends AbstractPlotLabel {
    private Font f = new Font("Courier", 0, 12);

    @Override
    public final void drawLabel(Graphics2D g2d, AbstractPlot plot) {
        FontMetrics fm = g2d.getFontMetrics(this.f);
        g2d.setFont(this.f);
        int h = fm.getAscent() / 2;
        if (plot.getPlotDrawColor() != null) {
            g2d.setColor(plot.getPlotDrawColor());
        } else {
            g2d.setColor(plot.getHost().getProjection().getThemeColor());
        }
        for (int i = 0; i < plot.getUserPoints().size(); ++i) {
            String s = Integer.toString(i);
            int w = fm.stringWidth(s) / 2;
            Point2D p = plot.getUserPoints().get(i);
            Point2D d = plot.getHost().getProjection().userToPixel(p);
            g2d.drawString(Integer.toString(i), (int)(d.getX() - (double)w), (int)(d.getY() + (double)h));
        }
    }
}

