/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.plot.spline;

import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.plot.PlotPlugin;
import org.jensoft.core.plugin.plot.painter.anchor.AbstractPlotAnchorPainter;
import org.jensoft.core.plugin.plot.painter.anchor.PlotAnchorDefaultPainter;
import org.jensoft.core.plugin.plot.painter.draw.AbstractPlotDraw;
import org.jensoft.core.plugin.plot.painter.draw.PlotDefaultDraw;
import org.jensoft.core.plugin.plot.painter.label.AbstractPlotLabel;
import org.jensoft.core.plugin.plot.painter.label.PlotDefaultLabel;
import org.jensoft.core.plugin.plot.spline.PlotAnchor;
import org.jensoft.core.projection.Projection;

public abstract class AbstractPlot {
    private List<Point2D> userPoints;
    private List<Point2D> devicePoints;
    private List<PlotAnchor> anchorsPoints;
    private GeneralPath plotPath;
    private PlotAnchor selectedAnchor = null;
    private PlotPlugin host;
    private Color plotDrawColor;
    private AbstractPlotDraw plotDraw = new PlotDefaultDraw();
    private AbstractPlotLabel plotLabel = new PlotDefaultLabel();
    private AbstractPlotAnchorPainter plotAnchorsPainter = new PlotAnchorDefaultPainter();
    private final int EPSILON = 36;

    public AbstractPlot() {
        this.userPoints = new ArrayList<Point2D>();
    }

    public abstract void solvePlot();

    public void solvePlotAnchors() {
        Projection proj = this.getHost().getProjection();
        ArrayList<PlotAnchor> anchors = new ArrayList<PlotAnchor>();
        this.setAnchorsPoints(anchors);
        for (int i = 0; i < this.getUserPoints().size(); ++i) {
            PlotAnchor anchor = new PlotAnchor();
            anchor.setUserPoint(this.getUserPoints().get(i));
            anchor.setDevicePoint(proj.userToPixel(this.getUserPoints().get(i)));
            anchors.add(anchor);
        }
    }

    public AbstractPlotAnchorPainter getPlotAnchorsPainter() {
        return this.plotAnchorsPainter;
    }

    public void setPlotAnchorsPainter(AbstractPlotAnchorPainter plotAnchorsPainter) {
        this.plotAnchorsPainter = plotAnchorsPainter;
    }

    public List<PlotAnchor> getAnchorsPoints() {
        return this.anchorsPoints;
    }

    public void setAnchorsPoints(List<PlotAnchor> anchorsPoints) {
        this.anchorsPoints = anchorsPoints;
    }

    public AbstractPlotDraw getPlotDraw() {
        return this.plotDraw;
    }

    public void setPlotDraw(AbstractPlotDraw plotDraw) {
        this.plotDraw = plotDraw;
    }

    public AbstractPlotLabel getPlotLabel() {
        return this.plotLabel;
    }

    public void setPlotLabel(AbstractPlotLabel plotLabel) {
        this.plotLabel = plotLabel;
    }

    public List<Point2D> getUserPoints() {
        return this.userPoints;
    }

    public void setUserPoints(List<Point2D> userPoints) {
        this.userPoints = userPoints;
    }

    public List<Point2D> getDevicePoints() {
        return this.devicePoints;
    }

    public void setDevicePoints(List<Point2D> devicePoints) {
        this.devicePoints = devicePoints;
    }

    public GeneralPath getPlotPath() {
        return this.plotPath;
    }

    public void setPlotPath(GeneralPath plotPath) {
        this.plotPath = plotPath;
    }

    public PlotAnchor getPlotAnchor(int x, int y) {
        int mind = Integer.MAX_VALUE;
        PlotAnchor selectedAnchor = null;
        for (PlotAnchor anchor : this.anchorsPoints) {
            int d = this.sqr((int)(anchor.getDevicePoint().getX() - (double)x)) + this.sqr((int)(anchor.getDevicePoint().getY() - (double)y));
            if (d >= mind || d >= 36) continue;
            mind = d;
            selectedAnchor = anchor;
        }
        return selectedAnchor;
    }

    public PlotAnchor selectPlotAnchor(int x, int y) {
        this.selectedAnchor = this.getPlotAnchor(x, y);
        return this.selectedAnchor;
    }

    public PlotAnchor getSelectedAnchor() {
        return this.selectedAnchor;
    }

    private int sqr(int x) {
        return x * x;
    }

    public void addPoint(double x, double y) {
        this.userPoints.add(new Point2D.Double(x, y));
    }

    public void updateAnchorPoint(double x, double y) {
        if (this.selectedAnchor != null) {
            Point2D newPoint = this.getHost().getProjection().pixelToUser(new Point2D.Double(x, y));
            int index = this.getUserPointIndex(this.selectedAnchor.getUserPoint());
            if (index != -1) {
                this.userPoints.get(index).setLocation(newPoint);
            }
        }
    }

    public int getUserPointIndex(Point2D point) {
        for (int i = 0; i < this.userPoints.size(); ++i) {
            if (!this.userPoints.get(i).equals(point)) continue;
            return i;
        }
        return -1;
    }

    public void removePoint() {
        int index;
        if (this.selectedAnchor != null && (index = this.getUserPointIndex(this.selectedAnchor.getUserPoint())) != -1) {
            this.userPoints.remove(index);
        }
    }

    public PlotPlugin getHost() {
        return this.host;
    }

    public void setHost(PlotPlugin host) {
        this.host = host;
    }

    public Color getPlotDrawColor() {
        return this.plotDrawColor;
    }

    public void setPlotDrawColor(Color plotDrawColor) {
        this.plotDrawColor = plotDrawColor;
    }
}

