/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.plot.spline;

import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jensoft.core.plugin.plot.spline.AbstractPlot;
import org.jensoft.core.projection.Projection;

public class BSpline
extends AbstractPlot {
    private final int STEPS = 40;

    float b(int i, float t) {
        switch (i) {
            case -2: {
                return (((-t + 3.0f) * t - 3.0f) * t + 1.0f) / 6.0f;
            }
            case -1: {
                return ((3.0f * t - 6.0f) * t * t + 4.0f) / 6.0f;
            }
            case 0: {
                return (((-3.0f * t + 3.0f) * t + 3.0f) * t + 1.0f) / 6.0f;
            }
            case 1: {
                return t * t * t / 6.0f;
            }
        }
        return 0.0f;
    }

    private Point2D p(int i, float t) {
        float px = 0.0f;
        float py = 0.0f;
        for (int j = -2; j <= 1; ++j) {
            px = (float)((double)px + (double)this.b(j, t) * this.getUserPoints().get(i + j).getX());
            py = (float)((double)py + (double)this.b(j, t) * this.getUserPoints().get(i + j).getY());
        }
        return new Point2D.Double(px, py);
    }

    @Override
    public void solvePlot() {
        Projection w2d = this.getHost().getProjection();
        GeneralPath path = new GeneralPath();
        ArrayList<Point2D> devicePoints = new ArrayList<Point2D>();
        Point2D q = this.p(2, 0.0f);
        Point2D moveTo = w2d.userToPixel(q);
        devicePoints.add(moveTo);
        path.moveTo(moveTo.getX(), moveTo.getY());
        for (int i = 2; i < this.getUserPoints().size() - 1; ++i) {
            for (int j = 1; j <= 40; ++j) {
                q = this.p(i, (float)j / 40.0f);
                Point2D up = w2d.userToPixel(q);
                devicePoints.add(up);
                path.lineTo(up.getX(), up.getY());
            }
        }
        this.setPlotPath(path);
        this.setDevicePoints(devicePoints);
    }
}

