/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.plot.spline;

import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jensoft.core.plugin.plot.spline.AbstractPlot;

public class Bezier
extends AbstractPlot {
    private final int STEPS = 10;

    private double b(int i, double t) {
        switch (i) {
            case 0: {
                return (1.0 - t) * (1.0 - t) * (1.0 - t);
            }
            case 1: {
                return 3.0 * t * (1.0 - t) * (1.0 - t);
            }
            case 2: {
                return 3.0 * t * t * (1.0 - t);
            }
            case 3: {
                return t * t * t;
            }
        }
        return 0.0;
    }

    private Point2D p(int i, double t) {
        double px = 0.0;
        double py = 0.0;
        for (int j = 0; j <= 3; ++j) {
            px += this.b(j, t) * this.getUserPoints().get(i + j).getX();
            py += this.b(j, t) * this.getUserPoints().get(i + j).getY();
        }
        return new Point2D.Double(px, py);
    }

    @Override
    public void solvePlot() {
        GeneralPath path = new GeneralPath();
        ArrayList<Point2D> devicePoints = new ArrayList<Point2D>();
        Point2D q = this.p(0, 0.0);
        Point2D uq = this.getHost().getProjection().userToPixel(q);
        devicePoints.add(uq);
        path.moveTo(uq.getX(), uq.getY());
        for (int i = 0; i < this.getUserPoints().size() - 3; i += 3) {
            for (int j = 1; j <= 10; ++j) {
                q = this.p(i, (float)j / 10.0f);
                uq = this.getHost().getProjection().userToPixel(q);
                devicePoints.add(uq);
                path.lineTo(uq.getX(), uq.getY());
            }
        }
        this.setPlotPath(path);
        this.setDevicePoints(devicePoints);
    }
}

