/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.plot.spline;

import java.awt.geom.Point2D;
import org.jensoft.core.plugin.plot.spline.Bezier;

public class BezierG1
extends Bezier {
    private double deltax;
    private double deltay;

    private void forceCollinear(int i) {
        if (i % 3 == 0 && i < this.getUserPoints().size() - 1 && i > 0) {
            this.getUserPoints().get(i - 1).setLocation(this.getUserPoints().get(i - 1).getX() + this.deltax, this.getUserPoints().get(i - 1).getY() + this.deltay);
            this.getUserPoints().get(i + 1).setLocation(this.getUserPoints().get(i + 1).getX() + this.deltax, this.getUserPoints().get(i + 1).getY() + this.deltay);
        } else if (i % 3 == 1 && i > 1) {
            this.forceCollinear(i, i - 1, i - 2);
        } else if (i % 3 == 2 && i < this.getUserPoints().size() - 2) {
            this.forceCollinear(i, i + 1, i + 2);
        }
    }

    private void forceCollinear(int i, int j, int k) {
        float ij = this.distance(this.getUserPoints().get(i).getX(), this.getUserPoints().get(i).getY(), this.getUserPoints().get(j).getX(), this.getUserPoints().get(j).getY());
        float jk = this.distance(this.getUserPoints().get(j).getX(), this.getUserPoints().get(j).getY(), this.getUserPoints().get(k).getX(), this.getUserPoints().get(k).getY());
        float r = jk / ij;
        double kx = this.getUserPoints().get(j).getX() + (double)r * (this.getUserPoints().get(j).getX() - this.getUserPoints().get(i).getX());
        double ky = this.getUserPoints().get(j).getY() + (double)r * (this.getUserPoints().get(j).getY() - this.getUserPoints().get(i).getY());
        this.getUserPoints().get(k).setLocation(kx, ky);
    }

    private float distance(double x1, double y1, double x2, double y2) {
        return (float)Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    @Override
    public void solvePlot() {
        for (int i = 4; i < this.getUserPoints().size(); i += 3) {
            this.forceCollinear(i);
        }
        super.solvePlot();
    }

    @Override
    public void updateAnchorPoint(double x, double y) {
        Point2D pixelUser = this.getHost().getProjection().pixelToUser(new Point2D.Double(x, y));
        this.deltax = pixelUser.getX() - this.getSelectedAnchor().getUserPoint().getX();
        this.deltay = pixelUser.getY() - this.getSelectedAnchor().getUserPoint().getY();
        super.updateAnchorPoint(x, y);
    }

    @Override
    public void removePoint() {
        super.removePoint();
        for (int i = 4; i < this.getUserPoints().size(); i += 3) {
            this.forceCollinear(i);
        }
    }
}

