/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.plot.spline;

import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jensoft.core.plugin.plot.spline.AbstractPlot;
import org.jensoft.core.plugin.plot.spline.Cubic;
import org.jensoft.core.projection.Projection;

public class NatCubic
extends AbstractPlot {
    private final int STEPS = 12;

    Cubic[] calcNaturalCubic(int n, double[] x) {
        int i;
        double[] gamma = new double[n + 1];
        double[] delta = new double[n + 1];
        double[] D = new double[n + 1];
        gamma[0] = 0.5;
        for (i = 1; i < n; ++i) {
            gamma[i] = 1.0 / (4.0 - gamma[i - 1]);
        }
        gamma[n] = 1.0 / (2.0 - gamma[n - 1]);
        delta[0] = 3.0 * (x[1] - x[0]) * gamma[0];
        for (i = 1; i < n; ++i) {
            delta[i] = (3.0 * (x[i + 1] - x[i - 1]) - delta[i - 1]) * gamma[i];
        }
        delta[n] = (3.0 * (x[n] - x[n - 1]) - delta[n - 1]) * gamma[n];
        D[n] = delta[n];
        for (i = n - 1; i >= 0; --i) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
        }
        Cubic[] C = new Cubic[n];
        for (i = 0; i < n; ++i) {
            C[i] = new Cubic(x[i], D[i], 3.0 * (x[i + 1] - x[i]) - 2.0 * D[i] - D[i + 1], 2.0 * (x[i] - x[i + 1]) + D[i] + D[i + 1]);
        }
        return C;
    }

    @Override
    public void solvePlot() {
        GeneralPath path = new GeneralPath();
        ArrayList<Point2D> devicePoints = new ArrayList<Point2D>();
        Projection w2d = this.getHost().getProjection();
        if (this.getUserPoints().size() >= 2) {
            double[] xvals = new double[this.getUserPoints().size()];
            double[] yvals = new double[this.getUserPoints().size()];
            int count = 0;
            for (Point2D p : this.getUserPoints()) {
                xvals[count] = p.getX();
                yvals[count] = p.getY();
                ++count;
            }
            Cubic[] X2 = this.calcNaturalCubic(this.getUserPoints().size() - 1, xvals);
            Cubic[] Y2 = this.calcNaturalCubic(this.getUserPoints().size() - 1, yvals);
            double x = w2d.userToPixelX(X2[0].eval(0.0));
            double y = w2d.userToPixelY(Y2[0].eval(0.0));
            path.moveTo(x, y);
            devicePoints.add(new Point2D.Double(x, y));
            for (int i = 0; i < X2.length; ++i) {
                for (int j = 1; j <= 12; ++j) {
                    double u = (double)j / 12.0;
                    x = w2d.userToPixelX(X2[i].eval(u));
                    y = w2d.userToPixelY(Y2[i].eval(u));
                    devicePoints.add(new Point2D.Double(x, y));
                    path.lineTo(x, y);
                }
            }
        }
        this.setPlotPath(path);
        this.setDevicePoints(devicePoints);
    }
}

