/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.point.manager;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.point.Point;
import org.jensoft.core.plugin.point.manager.AbstractPointManager;

public class DynamicPointAreaManager
extends AbstractPointManager {
    private double xRef;
    private double yRef;
    private double weighX;
    private double weighY;
    private List<Point> points = new ArrayList<Point>();

    public DynamicPointAreaManager(double xRef, double yRef, double weighX, double weighY) {
        super.setType(2);
        this.xRef = xRef;
        this.yRef = yRef;
        this.weighX = weighX;
        this.weighY = weighY;
    }

    @Override
    public List<Point> getPoints() {
        int y2;
        Point p;
        Point2D p2dDevice;
        Point2D.Double p2dUser;
        int y1;
        this.points.clear();
        double currentX = 0.0;
        double currentY1 = 0.0;
        double currentY2 = 0.0;
        double deltaX1 = this.getProjection().getMaxX() - this.xRef;
        double deltaY11 = this.getProjection().getMaxY() - this.yRef;
        double deltaY12 = Math.abs(this.getProjection().getMinY() - this.yRef);
        int numberIterX1 = (int)(deltaX1 / this.weighX);
        int numberIterY11 = (int)(deltaY11 / this.weighY);
        int numberIterY12 = (int)(deltaY12 / this.weighY);
        double deltaX2 = Math.abs(this.getProjection().getMinX() - this.xRef);
        double numberIterX2 = (int)(deltaX2 / this.weighX);
        for (int x1 = 0; x1 <= numberIterX1; ++x1) {
            currentX = this.xRef + (double)x1 * this.weighX;
            for (y1 = 0; y1 < numberIterY11; ++y1) {
                currentY1 = this.yRef + (double)y1 * this.weighY;
                p2dUser = new Point2D.Double(currentX, currentY1);
                p2dDevice = this.getProjection().userToPixel(p2dUser);
                p = new Point(2);
                p.value = p2dDevice;
                p.setColor(this.getPointColor());
                this.points.add(p);
            }
            for (y2 = 0; y2 < numberIterY12; ++y2) {
                currentY2 = this.yRef - (double)y2 * this.weighY;
                p2dUser = new Point2D.Double(currentX, currentY2);
                p2dDevice = this.getProjection().userToPixel(p2dUser);
                p = new Point(2);
                p.value = p2dDevice;
                p.setColor(this.getPointColor());
                this.points.add(p);
            }
        }
        int x2 = 0;
        while ((double)x2 <= numberIterX2) {
            currentX = this.xRef - (double)x2 * this.weighX;
            for (y1 = 0; y1 < numberIterY11; ++y1) {
                currentY1 = this.yRef + (double)y1 * this.weighY;
                p2dUser = new Point2D.Double(currentX, currentY1);
                p2dDevice = this.getProjection().userToPixel(p2dUser);
                p = new Point(2);
                p.value = p2dDevice;
                p.setColor(this.getPointColor());
                this.points.add(p);
            }
            for (y2 = 0; y2 < numberIterY12; ++y2) {
                currentY2 = this.yRef - (double)y2 * this.weighY;
                p2dUser = new Point2D.Double(currentX, currentY2);
                p2dDevice = this.getProjection().userToPixel(p2dUser);
                p = new Point(2);
                p.value = p2dDevice;
                p.setColor(this.getPointColor());
                this.points.add(p);
            }
            ++x2;
        }
        return this.points;
    }
}

