/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.point.manager;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.point.Point;
import org.jensoft.core.plugin.point.manager.AbstractPointManager;

public class FlowPointManager
extends AbstractPointManager {
    private Point2D pointStart;
    private double widthMax;
    private double flowWeigh;
    private List<Point> devicePoints = new ArrayList<Point>();

    public FlowPointManager(int type, Point2D pointRef, double pointMax, double flowWidth) {
        super.setType(type);
        this.pointStart = pointRef;
        this.widthMax = pointMax;
        this.flowWeigh = flowWidth;
    }

    @Override
    public List<Point> getPoints() {
        this.devicePoints.clear();
        double interval = this.widthMax - this.pointStart.getX();
        int gridNumber = (int)(interval / this.flowWeigh);
        if (gridNumber > 0) {
            for (int i = 0; i <= gridNumber; ++i) {
                Point p;
                Point2D p2ddevice;
                Point2D.Double p2dUser;
                double g = this.pointStart.getX() + (double)i * this.flowWeigh;
                if (this.getType() == 0) {
                    g = this.pointStart.getX() + (double)i * this.flowWeigh;
                    p2dUser = new Point2D.Double(g, this.pointStart.getY());
                    p2ddevice = this.getProjection().userToPixel(p2dUser);
                    p = new Point(0);
                    p.value = p2ddevice;
                    p.setColor(this.getPointColor());
                    this.devicePoints.add(p);
                    continue;
                }
                if (this.getType() != 1) continue;
                g = this.pointStart.getY() + (double)i * this.flowWeigh;
                p2dUser = new Point2D.Double(this.pointStart.getX(), g);
                p2ddevice = this.getProjection().userToPixel(p2dUser);
                p = new Point(1);
                p.value = p2ddevice;
                p.setColor(this.getPointColor());
                this.devicePoints.add(p);
            }
        }
        return this.devicePoints;
    }
}

