/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.progress;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class ProgressDevicePlugin
extends AbstractPlugin {
    boolean lockProgress = false;
    private double currentProgress = 0.0;

    public ProgressDevicePlugin() {
        this.setName("ProgressPlugin");
    }

    public void start() {
        this.lockProgress = true;
    }

    public void stop() {
        this.lockProgress = false;
    }

    public void setCurentProcess(double currentScanValue) {
        this.currentProgress = currentScanValue;
    }

    private void paintScanningProcess(Graphics2D g2d) {
        Projection w2d = this.getProjection();
        Point2D.Double p2dUser = new Point2D.Double(this.currentProgress, 0.0);
        Point2D p2ddevice = w2d.userToPixel(p2dUser);
        Rectangle2D.Double recZone2D = new Rectangle2D.Double(0.0, 0.0, p2ddevice.getX(), this.getProjection().getDevice2D().getDeviceHeight());
        g2d.setPaint(this.getProjection().getThemeColor());
        g2d.setComposite(AlphaComposite.getInstance(3, 0.3f));
        g2d.fill(recZone2D);
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        String annotation = "Current Process : " + this.currentProgress;
        g2d.setFont(new Font("Tahoma", 0, 10));
        g2d.setColor(Color.BLACK);
        g2d.drawString(annotation, 5, 20);
    }

    @Override
    protected void paintPlugin(View v2d, Graphics2D g2d, ViewPart viewPart) {
        if (viewPart != ViewPart.Device) {
            return;
        }
        if (this.lockProgress) {
            this.paintScanningProcess(g2d);
        }
    }
}

