/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.radar;

import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.palette.color.ColorPalette;
import org.jensoft.core.plugin.radar.RadarDimension;
import org.jensoft.core.plugin.radar.RadarPlugin;
import org.jensoft.core.plugin.radar.RadarSurface;
import org.jensoft.core.plugin.radar.painter.RadarPainter;

public class Radar {
    private int centerX;
    private int centerY;
    private int buildCenterX;
    private int buildCenterY;
    private double radius;
    private RadarPainter painter;
    private RadarNature nature = RadarNature.User;
    private List<RadarDimension> dimensions;
    private List<RadarSurface> surfaces;
    private RadarPlugin host;
    private Color themeColor;

    public Radar(int centerX, int centerY, int radius) {
        this.centerX = centerX;
        this.centerY = centerY;
        this.radius = radius;
        this.dimensions = new ArrayList<RadarDimension>();
        this.surfaces = new ArrayList<RadarSurface>();
    }

    public Radar(int centerX, int centerY, int radius, RadarNature nature) {
        this.centerX = centerX;
        this.centerY = centerY;
        this.radius = radius;
        this.nature = nature;
        this.dimensions = new ArrayList<RadarDimension>();
        this.surfaces = new ArrayList<RadarSurface>();
    }

    public void addDimension(RadarDimension radarDimension) {
        this.dimensions.add(radarDimension);
    }

    public void addSurface(RadarSurface radarSurface) {
        radarSurface.setHost(this);
        this.surfaces.add(radarSurface);
    }

    public int getCenterX() {
        return this.centerX;
    }

    public void setCenterX(int centerX) {
        this.centerX = centerX;
    }

    public int getCenterY() {
        return this.centerY;
    }

    public void setCenterY(int centerY) {
        this.centerY = centerY;
    }

    public List<RadarDimension> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(List<RadarDimension> dimensions) {
        this.dimensions = dimensions;
    }

    public List<RadarSurface> getSurfaces() {
        return this.surfaces;
    }

    public void setSurfaces(List<RadarSurface> surfaces) {
        this.surfaces = surfaces;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public RadarPainter getPainter() {
        return this.painter;
    }

    public void setRadarPainter(RadarPainter painter) {
        this.painter = painter;
    }

    public RadarNature getNature() {
        return this.nature;
    }

    public void setNature(RadarNature nature) {
        this.nature = nature;
    }

    public int getBuildCenterX() {
        return this.buildCenterX;
    }

    public void setBuildCenterX(int buildCenterX) {
        this.buildCenterX = buildCenterX;
    }

    public int getBuildCenterY() {
        return this.buildCenterY;
    }

    public void setBuildCenterY(int buildCenterY) {
        this.buildCenterY = buildCenterY;
    }

    public RadarPlugin getHost() {
        return this.host;
    }

    public void setHost(RadarPlugin host) {
        this.host = host;
    }

    public Color getThemeColor() {
        if (this.themeColor == null) {
            this.themeColor = ColorPalette.getRandomColor();
        }
        return this.themeColor;
    }

    public void setThemeColor(Color themeColor) {
        this.themeColor = themeColor;
    }

    public Point2D getDimensionPointAtRadius(RadarDimension dimension, double radius) {
        if (this.nature == RadarNature.User) {
            Point2D projectedCenter = this.getHost().getProjection().userToPixel(new Point2D.Double(this.centerX, this.centerY));
            this.buildCenterX = (int)projectedCenter.getX();
            this.buildCenterY = (int)projectedCenter.getY();
        } else {
            this.buildCenterX = this.centerX;
            this.buildCenterY = this.centerY;
        }
        double angleDegree = dimension.getAngleDegree();
        double pointX = (double)this.buildCenterX + radius * Math.cos(Math.toRadians(angleDegree));
        double pointY = (double)this.buildCenterY - radius * Math.sin(Math.toRadians(angleDegree));
        Point2D.Double p = new Point2D.Double(pointX, pointY);
        return p;
    }

    public void solveGeometry() {
        for (RadarDimension dimension : this.dimensions) {
            if (this.nature == RadarNature.User) {
                Point2D projectedCenter = this.getHost().getProjection().userToPixel(new Point2D.Double(this.centerX, this.centerY));
                this.buildCenterX = (int)projectedCenter.getX();
                this.buildCenterY = (int)projectedCenter.getY();
            } else {
                this.buildCenterX = this.centerX;
                this.buildCenterY = this.centerY;
            }
            double angleDegree = dimension.getAngleDegree();
            double dimensionEndX = (double)this.buildCenterX + this.radius * Math.cos(Math.toRadians(angleDegree));
            double dimensionEndY = (double)this.buildCenterY - this.radius * Math.sin(Math.toRadians(angleDegree));
            Line2D.Double dimensionLine = new Line2D.Double(this.buildCenterX, this.buildCenterY, dimensionEndX, dimensionEndY);
            dimension.setDimensionLine(dimensionLine);
        }
    }

    public static enum RadarNature {
        Device,
        User;

    }
}

