/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.radar;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.jensoft.core.glyphmetrics.AbstractMetricsPath;
import org.jensoft.core.glyphmetrics.GeneralMetricsPath;
import org.jensoft.core.palette.color.ColorPalette;
import org.jensoft.core.plugin.radar.DimensionMetrics;
import org.jensoft.core.plugin.radar.RadarMetrics;
import org.jensoft.core.plugin.radar.painter.dimension.AbstractDimensionPainter;
import org.jensoft.core.plugin.radar.painter.dimension.DimensionDefaultPainter;
import org.jensoft.core.plugin.radar.painter.label.AbstractRadarDimensionLabel;

public class RadarDimension {
    private String name = "dimension";
    private double angleDegree = 0.0;
    private Line2D dimensionLine;
    private GeneralMetricsPath metricsPath;
    private AbstractDimensionPainter dimensionPainter;
    private AbstractRadarDimensionLabel dimensionLabel;
    private Color lineColor;
    private Stroke lineStroke = new BasicStroke();
    private Color themeColor;

    public RadarDimension() {
        this.initDimension();
    }

    public RadarDimension(double angleDegree, double minDimension, double maxDimension) {
        this.initDimension();
        this.angleDegree = angleDegree;
        this.metricsPath.setMin(minDimension);
        this.metricsPath.setMax(maxDimension);
    }

    public RadarDimension(String name, double angleDegree, double minDimension, double maxDimension) {
        this.initDimension();
        this.name = name;
        this.angleDegree = angleDegree;
        this.metricsPath.setMin(minDimension);
        this.metricsPath.setMax(maxDimension);
    }

    public RadarDimension(String name, Color lineColor, double angleDegree, double minDimension, double maxDimension) {
        this.initDimension();
        this.name = name;
        this.lineColor = lineColor;
        this.angleDegree = angleDegree;
        this.metricsPath.setMin(minDimension);
        this.metricsPath.setMax(maxDimension);
    }

    private void initDimension() {
        this.metricsPath = new GeneralMetricsPath();
        this.metricsPath.setProjectionNature(AbstractMetricsPath.ProjectionNature.DEVICE);
        this.metricsPath.setAutoReverseGlyph(true);
        this.dimensionPainter = new DimensionDefaultPainter();
    }

    public Stroke getLineStroke() {
        return this.lineStroke;
    }

    public void setLineStroke(Stroke lineStroke) {
        this.lineStroke = lineStroke;
    }

    public AbstractDimensionPainter getDimensionPainter() {
        return this.dimensionPainter;
    }

    public void setDimensionPainter(AbstractDimensionPainter dimensionPainter) {
        this.dimensionPainter = dimensionPainter;
    }

    public Color getThemeColor() {
        if (this.themeColor == null) {
            this.themeColor = ColorPalette.getRandomColor();
        }
        return this.themeColor;
    }

    public void setThemeColor(Color themeColor) {
        this.themeColor = themeColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addMetrics(DimensionMetrics dimensionMetrics) {
        double metricsValue = dimensionMetrics.getValue();
        if (metricsValue < this.getMinDimension() || metricsValue > this.getMaxDimension()) {
            throw new IllegalArgumentException("dimension metrics value out of dimension range.");
        }
        this.metricsPath.addMetric(dimensionMetrics);
    }

    public double getAngleDegree() {
        return this.angleDegree;
    }

    public void setAngleDegree(double angleDegree) {
        this.angleDegree = angleDegree;
    }

    public double getMinDimension() {
        return this.metricsPath.getMin();
    }

    public void setMinDimension(double minDimension) {
        this.metricsPath.setMin(minDimension);
        this.metricsPath.resetPath();
    }

    public double getMaxDimension() {
        return this.metricsPath.getMax();
    }

    public void setMaxDimension(double maxDimension) {
        this.metricsPath.setMax(maxDimension);
        this.metricsPath.resetPath();
    }

    public Line2D getDimensionLine() {
        return this.dimensionLine;
    }

    public void setDimensionLine(Line2D dimensionLine) {
        this.dimensionLine = dimensionLine;
        this.metricsPath.resetPath();
        this.metricsPath.append(dimensionLine);
    }

    public Point2D getMetricsPoint(double value) {
        return this.metricsPath.getMetricsPoint(value);
    }

    public void solveMetrics(RadarMetrics radarMetrics) {
        this.metricsPath.solveMetrics(radarMetrics);
    }

    public GeneralMetricsPath getMetricsPath() {
        return this.metricsPath;
    }

    public AbstractRadarDimensionLabel getDimensionLabel() {
        return this.dimensionLabel;
    }

    public void setDimensionLabel(AbstractRadarDimensionLabel dimensionLabel) {
        this.dimensionLabel = dimensionLabel;
    }
}

