/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.radar;

import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.palette.color.ColorPalette;
import org.jensoft.core.plugin.radar.Radar;
import org.jensoft.core.plugin.radar.RadarSurfaceAnchor;
import org.jensoft.core.plugin.radar.painter.AbstractRadarSurfacePainter;

public class RadarSurface {
    private String name = "surface";
    private Radar host;
    private Color themeColor;
    private List<RadarSurfaceAnchor> anchors = new ArrayList<RadarSurfaceAnchor>();
    private GeneralPath surfacePath;
    private AbstractRadarSurfacePainter surfacePainter;

    public RadarSurface() {
    }

    public RadarSurface(String name) {
        this.name = name;
    }

    public Radar getHost() {
        return this.host;
    }

    public void setHost(Radar host) {
        this.host = host;
    }

    public Color getThemeColor() {
        if (this.themeColor == null) {
            this.themeColor = ColorPalette.getRandomColor();
        }
        return this.themeColor;
    }

    public void setThemeColor(Color themeColor) {
        this.themeColor = themeColor;
    }

    public List<RadarSurfaceAnchor> getAnchors() {
        return this.anchors;
    }

    public void addSurfaceAnchor(RadarSurfaceAnchor surfaceAnchor) {
        this.anchors.add(surfaceAnchor);
    }

    public AbstractRadarSurfacePainter getSurfacePainter() {
        return this.surfacePainter;
    }

    public void setSurfacePainter(AbstractRadarSurfacePainter surfacePainter) {
        this.surfacePainter = surfacePainter;
    }

    public void solveSurfaceGeometry() {
        if (this.getAnchors().size() == 0) {
            return;
        }
        System.out.println("radar:" + this.getHost());
        int x = this.getHost().getBuildCenterX();
        int y = this.getHost().getBuildCenterY();
        List<RadarSurfaceAnchor> anchors = this.getAnchors();
        this.surfacePath = new GeneralPath();
        this.surfacePath.moveTo(x, y);
        for (int i = 0; i < anchors.size(); ++i) {
            RadarSurfaceAnchor anchor = anchors.get(i);
            Point2D point = anchor.getDimension().getMetricsPoint(anchor.getRadarMetrics().getValue());
            if (point == null) continue;
            this.surfacePath.lineTo(point.getX(), point.getY());
        }
        this.surfacePath.closePath();
    }

    public GeneralPath getSurfacePath() {
        return this.surfacePath;
    }
}

