/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.radar;

import org.jensoft.core.plugin.radar.AnchorMetrics;
import org.jensoft.core.plugin.radar.RadarDimension;
import org.jensoft.core.plugin.radar.RadarMetrics;

public class RadarSurfaceAnchor {
    private RadarDimension dimension;
    private RadarMetrics radarMetrics;
    private boolean metricsEnable = false;

    public RadarSurfaceAnchor(RadarDimension dimension, AnchorMetrics radarMetrics) {
        double metricsValue = radarMetrics.getValue();
        if (metricsValue < dimension.getMinDimension() || metricsValue > dimension.getMaxDimension()) {
            throw new IllegalArgumentException("anchor metrics value out of dimension range.");
        }
        this.dimension = dimension;
        this.radarMetrics = radarMetrics;
    }

    public RadarDimension getDimension() {
        return this.dimension;
    }

    public void setDimension(RadarDimension dimension) {
        this.dimension = dimension;
    }

    public RadarMetrics getRadarMetrics() {
        return this.radarMetrics;
    }

    public void setRadarMetrics(RadarMetrics radarMetrics) {
        this.radarMetrics = radarMetrics;
    }

    public boolean isMetricsEnable() {
        return this.metricsEnable;
    }

    public void setMetricsEnable(boolean metricsEnable) {
        this.metricsEnable = metricsEnable;
    }
}

