/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.radar;

import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.radar.Radar;
import org.jensoft.core.plugin.radar.RadarPlugin;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;

public class RadarView
extends View {
    private static final long serialVersionUID = -8598481995145789973L;
    private Projection.Linear radarProjection;
    private RadarPlugin radarPlugin;

    public RadarView() {
        this.setPlaceHolderAxisNorth(60);
        this.setPlaceHolderAxisSouth(60);
        this.setPlaceHolderAxisWest(60);
        this.setPlaceHolderAxisEast(60);
        this.createProjection();
        this.registerPlugin();
    }

    private void createProjection() {
        this.radarProjection = new Projection.Linear(-1.0, 1.0, -1.0, 1.0);
        this.radarProjection.setName("compatible radar projection");
        this.registerProjection(this.radarProjection);
    }

    private void registerPlugin() {
        this.radarPlugin = new RadarPlugin();
        this.radarPlugin.setPriority(100);
        this.radarProjection.registerPlugin(this.radarPlugin);
    }

    public void registerPlugin(AbstractPlugin plugin) {
        this.radarProjection.registerPlugin(plugin);
    }

    public void addRadar(Radar radar) {
        this.radarPlugin.addRadar(radar);
    }

    public Projection.Linear getProjection() {
        return this.radarProjection;
    }

    public RadarPlugin getRadarPlugin() {
        return this.radarPlugin;
    }
}

